/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.StringUtils;
import com.sun.grizzly.config.dom.NetworkListener;
import java.util.List;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.config.support.PropertyResolver;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;

public final class RemoteInstanceCommandHelper {
    private final List<Server> servers;
    private final List<Config> configs;
    private final Nodes nodes;
    private final Habitat habitat;
    private final Domain domain;

    public RemoteInstanceCommandHelper(Habitat habitatIn) {
        try {
            this.habitat = habitatIn;
            this.configs = ((Configs)this.habitat.getByType(Configs.class)).getConfig();
            this.servers = ((Servers)this.habitat.getByType(Servers.class)).getServer();
            this.domain = (Domain)this.habitat.getByType(Domain.class);
            this.nodes = (Nodes)this.habitat.getByType(Nodes.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final String getHost(String serverName) {
        String host = null;
        Server server = this.getServer(serverName);
        if (server != null) {
            host = server.getHost();
        }
        return host;
    }

    public final Server getServer(String serverName) {
        for (Server server : this.servers) {
            String name = server.getName();
            if (!(serverName == null ? name == null : serverName.equals(name))) continue;
            return server;
        }
        return null;
    }

    public final String getNode(Server server) {
        if (server == null) {
            return null;
        }
        String node = server.getNode();
        if (StringUtils.ok(node)) {
            return node;
        }
        return "no node";
    }

    public final int getAdminPort(String serverName) {
        return this.getAdminPort(this.getServer(serverName));
    }

    public final int getAdminPort(Server server) {
        String portString = this.getAdminPortString(server, this.getConfig(server));
        if (portString == null) {
            return -1;
        }
        try {
            return Integer.parseInt(portString);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private String getAdminPortString(Server server, Config config) {
        if (server == null || config == null) {
            return null;
        }
        try {
            List listeners = config.getNetworkConfig().getNetworkListeners().getNetworkListener();
            for (NetworkListener listener : listeners) {
                if (!"admin-listener".equals(listener.getProtocol())) continue;
                return this.translatePort(listener, server);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Config getConfig(Server server) {
        if (server == null) {
            return null;
        }
        String cfgName = server.getConfigRef();
        if (cfgName == null) {
            return null;
        }
        for (Config config : this.configs) {
            if (!cfgName.equals(config.getName())) continue;
            return config;
        }
        return null;
    }

    private String translatePort(NetworkListener adminListener, Server server) {
        NetworkListener adminListenerRaw = null;
        try {
            adminListenerRaw = (NetworkListener)GlassFishConfigBean.getRawView((ConfigBeanProxy)adminListener);
            String portString = adminListenerRaw.getPort();
            if (!RemoteInstanceCommandHelper.isToken(portString)) {
                return portString;
            }
            PropertyResolver resolver = new PropertyResolver(this.domain, server.getName());
            return resolver.getPropertyValue(portString);
        }
        catch (ClassCastException e) {
            return this.translatePortOld(adminListener.getPort(), server, this.getConfig(server));
        }
    }

    private String translatePortOld(String portString, Server server, Config config) {
        if (!RemoteInstanceCommandHelper.isToken(portString)) {
            return portString;
        }
        String key = portString.substring(2, portString.length() - 1);
        SystemProperty prop = server.getSystemProperty(key);
        if (prop != null) {
            return prop.getValue();
        }
        prop = config.getSystemProperty(key);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    private static boolean isToken(String s) {
        return s != null && s.startsWith("${") && s.endsWith("}") && s.length() > 3;
    }
}

