/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.Content;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;

public class AutoSignedContent
extends Content.Adapter
implements StaticContent {
    private final File unsignedFile;
    private final File signedFile;
    private final String userProvidedAlias;
    private final ASJarSigner jarSigner;

    public AutoSignedContent(File unsignedFile, File signedFile, String userProvidedAlias, ASJarSigner jarSigner) throws FileNotFoundException {
        if (!unsignedFile.exists() || !unsignedFile.canRead()) {
            throw new FileNotFoundException(unsignedFile.getAbsolutePath());
        }
        this.unsignedFile = unsignedFile;
        this.signedFile = signedFile;
        this.userProvidedAlias = userProvidedAlias;
        this.jarSigner = jarSigner;
    }

    public File file() throws IOException {
        return this.signedFile;
    }

    public boolean isAvailable() throws IOException {
        if (!this.isSignedFileReady()) {
            try {
                this.createSignedFile();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return super.isAvailable();
    }

    private boolean isSignedFileReady() {
        return this.signedFile.exists() && this.signedFile.lastModified() >= this.unsignedFile.lastModified();
    }

    private void createSignedFile() throws Exception {
        this.signedFile.getParentFile().mkdirs();
        this.jarSigner.signJar(this.unsignedFile, this.signedFile, this.userProvidedAlias);
    }

    public String toString() {
        return "AutoSignedContent:" + this.signedFile.getAbsolutePath();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoSignedContent other = (AutoSignedContent)obj;
        if (!(this.unsignedFile == other.unsignedFile || this.unsignedFile != null && this.unsignedFile.equals(other.unsignedFile))) {
            return false;
        }
        if (!(this.signedFile == other.signedFile || this.signedFile != null && this.signedFile.equals(other.signedFile))) {
            return false;
        }
        return !(this.userProvidedAlias == null ? other.userProvidedAlias != null : !this.userProvidedAlias.equals(other.userProvidedAlias));
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.unsignedFile != null ? this.unsignedFile.hashCode() : 0);
        hash = 83 * hash + (this.signedFile != null ? this.signedFile.hashCode() : 0);
        hash = 83 * hash + (this.userProvidedAlias != null ? this.userProvidedAlias.hashCode() : 0);
        return hash;
    }
}

