/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.ha.store.api.Storeable;
import org.glassfish.ha.store.spi.StorableMap;
import org.glassfish.web.ha.session.management.SessionAttributeMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeMetadata
implements Storeable {
    private Collection<SessionAttributeMetadata> entries;
    private String stringExtraParam;
    private StorableMap storableMap;
    private long version;
    private long maxInactiveInterval;
    private long lastAccessTime;
    private byte[] state;
    private static final transient int SAVE_ALL = 0;
    private static final transient int SAVE_EP = 1;
    private static final transient int SAVE_TIME_STAMP = 2;
    private transient int saveMode = 0;
    private transient Set<String> _dirtyAttributeNames = new HashSet<String>();
    private static transient Set<String> saveALL = new HashSet<String>();
    private static transient Set<String> saveEP = new HashSet<String>();

    public CompositeMetadata(long version, long lastAccessTime, long maxInactiveInterval, Collection<SessionAttributeMetadata> entries, byte[] state) {
        this.entries = entries;
        this.storableMap = new SessionAttributesMapImpl(entries);
        this.version = version;
        this.lastAccessTime = lastAccessTime;
        this.maxInactiveInterval = maxInactiveInterval;
        this.state = state;
        this.saveMode = 0;
    }

    public Collection<SessionAttributeMetadata> getEntries() {
        return this.entries;
    }

    public String getStringExtraParam() {
        return this.stringExtraParam;
    }

    public Object _getAttributeValue(String attrName) {
        Object result = null;
        if ("sessionAttributes".equals(attrName)) {
            result = this.getEntries();
        } else if ("state".equals(attrName)) {
            result = this.getState();
        }
        return result;
    }

    public Set<String> _getDirtyAttributeNames() {
        return this._dirtyAttributeNames;
    }

    public byte[] getState() {
        return this.state;
    }

    public long getVersion() {
        return 0L;
    }

    public long _storeable_getVersion() {
        return 0L;
    }

    public void _storeable_setVersion(long version) {
    }

    public long _storeable_getLastAccessTime() {
        return 0L;
    }

    public void _storeable_setLastAccessTime(long version) {
    }

    public long _storeable_getMaxIdleTime() {
        return 0L;
    }

    public void _storeable_setMaxIdleTime(long version) {
    }

    public String[] _storeable_getAttributeNames() {
        return new String[0];
    }

    public boolean[] _storeable_getDirtyStatus() {
        return new boolean[0];
    }

    public void _storeable_writeState(OutputStream os) throws IOException {
    }

    public void _storeable_readState(InputStream is) throws IOException {
    }

    static {
        saveALL.add("state");
        saveALL.add("extraParam");
        saveEP.add("extraParam");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SessionAttributesMapImpl
    implements StorableMap<String, byte[]> {
        Set<String> newKeys = new HashSet<String>();
        Set<String> modifiedKeys = new HashSet<String>();
        Set<String> deletedKeys = new HashSet<String>();
        Map<String, byte[]> map = new HashMap<String, byte[]>();

        SessionAttributesMapImpl(Collection<SessionAttributeMetadata> attrs) {
            for (SessionAttributeMetadata attr : attrs) {
                this.map.put(attr.getAttributeName(), attr.getState());
                if (attr.getOperation() == SessionAttributeMetadata.Operation.ADD) {
                    this.newKeys.add(attr.getAttributeName());
                    continue;
                }
                if (attr.getOperation() == SessionAttributeMetadata.Operation.UPDATE) {
                    this.modifiedKeys.add(attr.getAttributeName());
                    continue;
                }
                this.deletedKeys.add(attr.getAttributeName());
            }
        }

        public byte[] get(String name) {
            return this.map.get(name);
        }

        public Collection getDeletedKeys() {
            return this.deletedKeys;
        }

        public Collection getModifiedKeys() {
            return this.modifiedKeys;
        }

        public Collection getNewKeys() {
            return this.deletedKeys;
        }
    }
}

