/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-lifecycle-module")
@I18n(value="delete.lifecycle.module")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class DeleteLifecycleModuleCommand
implements AdminCommand {
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    public String target = "server";
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteLifecycleModuleCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        if (!this.deployment.isRegistered(this.name)) {
            report.setMessage(localStrings.getLocalString("lifecycle.notreg", "Lifecycle module {0} not registered", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ApplicationRef ref = this.domain.getApplicationRefInTarget(this.name, this.target);
        if (ref == null) {
            report.setMessage(localStrings.getLocalString("lifecycle.not.referenced.target", "Lifecycle module {0} is not referenced by target {1}", new Object[]{this.name, this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            this.deployment.unregisterAppFromDomainXML(this.name, this.target);
        }
        catch (Exception e) {
            report.setMessage("Failed to delete lifecycle module: " + e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

