/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.customvalidators.ConnectionPoolConstraint;
import com.sun.enterprise.config.serverbeans.customvalidators.ConnectionPoolErrorMessages;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPoolValidator
implements ConstraintValidator<ConnectionPoolConstraint, ResourcePool> {
    protected ConnectionPoolErrorMessages poolFaults;

    public void initialize(ConnectionPoolConstraint constraint) {
        this.poolFaults = constraint.value();
    }

    public boolean isValid(ResourcePool pool, ConstraintValidatorContext constraintValidatorContext) {
        ConnectorConnectionPool connPool;
        JdbcConnectionPool jdbcPool;
        if (this.poolFaults == ConnectionPoolErrorMessages.MAX_STEADY_INVALID && (pool instanceof JdbcConnectionPool ? Integer.parseInt((jdbcPool = (JdbcConnectionPool)pool).getMaxPoolSize()) < Integer.parseInt(jdbcPool.getSteadyPoolSize()) : pool instanceof ConnectorConnectionPool && Integer.parseInt((connPool = (ConnectorConnectionPool)pool).getMaxPoolSize()) < Integer.parseInt(connPool.getSteadyPoolSize()))) {
            return false;
        }
        if (this.poolFaults == ConnectionPoolErrorMessages.STMT_WRAPPING_DISABLED && pool instanceof JdbcConnectionPool) {
            jdbcPool = (JdbcConnectionPool)pool;
            if (jdbcPool.getSqlTraceListeners() != null && !Boolean.valueOf(jdbcPool.getWrapJdbcObjects()).booleanValue()) {
                return false;
            }
            if (Integer.valueOf(jdbcPool.getStatementCacheSize()) != 0 && !Boolean.valueOf(jdbcPool.getWrapJdbcObjects()).booleanValue()) {
                return false;
            }
        }
        if (this.poolFaults == ConnectionPoolErrorMessages.RES_TYPE_MANDATORY && pool instanceof JdbcConnectionPool) {
            jdbcPool = (JdbcConnectionPool)pool;
            String resType = jdbcPool.getResType();
            String dsClassName = jdbcPool.getDatasourceClassname();
            String driverClassName = jdbcPool.getDriverClassname();
            if (resType == null) {
                if ((dsClassName == null || dsClassName.equals("")) && (driverClassName == null || driverClassName.equals(""))) {
                    return false;
                }
                if (dsClassName != null && driverClassName != null) {
                    return false;
                }
            } else if (resType.equals("javax.sql.DataSource") || resType.equals("javax.sql.ConnectionPoolDataSource") || resType.equals("javax.sql.XADataSource") ? dsClassName == null || dsClassName.equals("") : resType.equals("java.sql.Driver") && (driverClassName == null || driverClassName.equals(""))) {
                return false;
            }
        }
        return true;
    }
}

