/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.GenericCommandModel;
import org.glassfish.config.support.GenericCreateCommand;
import org.glassfish.config.support.GenericCrudCommand;
import org.glassfish.config.support.Listing;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@Scoped(value=PerLookup.class)
public class GenericListCommand
extends GenericCrudCommand
implements AdminCommand {
    @Inject
    Habitat habitat;
    Class<? extends CrudResolver> resolverType;
    CommandModel model;
    Listing listing;
    static final Logger logger = LogDomains.getLogger(GenericCreateCommand.class, (String)"javax.enterprise.system.tools.admin");

    public void postConstruct() {
        super.postConstruct();
        this.listing = this.targetMethod.getAnnotation(Listing.class);
        this.resolverType = this.listing.resolver();
        try {
            this.model = new GenericCommandModel(null, null, this.habitat.getComponent(DomDocument.class), this.commandName, this.listing.resolver(), null);
            if (logger.isLoggable(this.level)) {
                for (String paramName : this.model.getParametersNames()) {
                    CommandModel.ParamModel param = this.model.getModelFor(paramName);
                    logger.fine("I take " + param.getName() + " parameters");
                }
            }
        }
        catch (Exception e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.command_model_exception", "Exception while creating the command model for the generic command {0} : {1}", new Object[]{this.commandName, e.getMessage()});
            logger.severe(msg);
            throw new ComponentException(msg, e);
        }
    }

    public void execute(AdminCommandContext context) {
        ActionReport result = context.getActionReport();
        InjectionManager manager = new InjectionManager();
        CrudResolver resolver = this.habitat.getComponent(this.resolverType);
        manager.inject((Object)resolver, this.getInjectionResolver());
        Object parentBean = resolver.resolve(context, this.parentType);
        if (parentBean == null) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.target_object_not_found", "The CrudResolver {0} could not find the configuration object of type {1} where instances of {2} should be added", new Object[]{resolver.getClass().toString(), this.parentType, this.targetType});
            result.failure(logger, msg);
            return;
        }
        try {
            List children = (List)this.targetMethod.invoke(parentBean, new Object[0]);
            for (ConfigBeanProxy child : children) {
                Dom childDom = Dom.unwrap(child);
                String key = childDom.getKey();
                if (key == null) {
                    String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericListCommand.element_has_no_key", "The element {0} has not key attribute", new Object[]{this.targetType});
                    result.failure(logger, msg);
                    return;
                }
                context.getActionReport().addSubActionsReport().setMessage(key);
            }
        }
        catch (Exception e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.method_invocation_exception", "Exception while invoking {0} method : {1}", new Object[]{this.targetMethod.toString(), e.toString()});
            result.failure(logger, msg, (Throwable)e);
        }
    }

    public CommandModel getModel() {
        return this.model;
    }
}

