/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.osgiadapter.BundleEventType;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiFactoryImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HK2Main
extends Main
implements BundleActivator,
SynchronousBundleListener {
    private BundleContext ctx;
    private ServiceRegistration mrReg;
    private Map<Habitat, HabitatInfo> habitatInfos = new HashMap<Habitat, HabitatInfo>();

    public Habitat createHabitat(ModulesRegistry registry, StartupContext context) throws BootException {
        HabitatInfo habitatInfo = new HabitatInfo();
        habitatInfo.habitat = super.createHabitat(registry, context);
        this.createHK2ServiceTracker(habitatInfo);
        habitatInfo.habitatRegistration = this.ctx.registerService(Habitat.class.getName(), (Object)habitatInfo.habitat, (Dictionary)context.getArguments());
        this.habitatInfos.put(habitatInfo.habitat, habitatInfo);
        return habitatInfo.habitat;
    }

    private void destroyHabitat(Habitat habitat) {
        HabitatInfo habitatInfo = this.habitatInfos.get(habitat);
        if (habitatInfo == null) {
            return;
        }
        habitatInfo.habitatRegistration.unregister();
        this.stopHK2ServiceTracker(habitatInfo);
        habitatInfo = null;
        this.habitatInfos.remove(habitat);
    }

    private void createHK2ServiceTracker(HabitatInfo habitatInfo) {
        habitatInfo.osgiServiceTracker = new ServiceTracker(this.ctx, (Filter)new NonHK2ServiceFilter(), (ServiceTrackerCustomizer)new HK2ServiceTrackerCustomizer(habitatInfo.habitat));
        habitatInfo.osgiServiceTracker.open(true);
    }

    private void stopHK2ServiceTracker(HabitatInfo habitatInfo) {
        if (habitatInfo.osgiServiceTracker != null) {
            habitatInfo.osgiServiceTracker.close();
            habitatInfo.osgiServiceTracker = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        this.ctx = context;
        Logger.logger.entering("HK2Main", "start", new Object[]{context});
        OSGiFactoryImpl.initialize(this.ctx);
        this.createModulesRegistry();
        this.ctx.registerService(Main.class.getName(), (Object)this, null);
    }

    protected void createModulesRegistry() {
        assert (this.mrReg == null);
        ModulesRegistry mr = AbstractFactory.getInstance().createModulesRegistry();
        this.mrReg = this.ctx.registerService(ModulesRegistry.class.getName(), (Object)mr, null);
    }

    protected void setParentClassLoader(StartupContext context, ModulesRegistry mr) throws BootException {
    }

    public void stop(BundleContext context) throws Exception {
        for (HabitatInfo habitatInfo : this.habitatInfos.values()) {
            Habitat habitat = habitatInfo.habitat;
            habitatInfo.habitat.getClass();
            ModuleStartup startupService = (ModuleStartup)habitat.getComponent(ModuleStartup.class, "_HABITAT_DEFAULT");
            if (startupService != null) {
                try {
                    Logger.logger.info("Stopping " + startupService);
                    startupService.stop();
                }
                catch (Exception e) {
                    Logger.logger.log(Level.WARNING, "HK2Main:stop():Exception while stopping ModuleStartup service.", e);
                }
            }
            this.destroyHabitat(habitatInfo.habitat);
        }
        ModulesRegistry mr = (ModulesRegistry)this.ctx.getService(this.mrReg.getReference());
        if (mr != null) {
            mr.shutdown();
            mr = null;
        }
    }

    public void bundleChanged(BundleEvent event) {
        Logger.logger.logp(Level.FINE, "HK2Main", "bundleChanged", "source= {0}, type= {1}", new Object[]{event.getSource(), BundleEventType.valueOf(event.getType())});
    }

    private class HK2ServiceTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private final Habitat habitat;

        private HK2ServiceTrackerCustomizer(Habitat habitat) {
            this.habitat = habitat;
        }

        public Object addingService(ServiceReference reference) {
            Object object = HK2Main.this.ctx.getService(reference);
            String[] contractNames = (String[])reference.getProperty("objectclass");
            if (contractNames != null && contractNames.length > 0) {
                for (String contractName : contractNames) {
                    String name = (String)reference.getProperty("component.name");
                    if (name == null) {
                        name = (String)reference.getProperty("org.springframework.osgi.bean.name");
                    }
                    this.habitat.addIndex((Inhabitant)new ExistingSingletonInhabitant(object), contractName, name);
                    Logger.logger.logp(Level.FINE, "HK2Main$HK2ServiceTrackerCustomizer", "addingService", "registering service = {0}, contract = {1}, name = {2}", new Object[]{object, contractName, name});
                }
            } else {
                this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(object));
                Logger.logger.logp(Level.FINE, "HK2Main$HK2ServiceTrackerCustomizer", "addingService", "registering service = {0}", object);
            }
            return object;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            String[] contractNames = (String[])reference.getProperty("objectclass");
            if (contractNames != null && contractNames.length > 0) {
                for (String contractName : contractNames) {
                    this.habitat.removeIndex(contractName, service);
                    Logger.logger.logp(Level.FINE, "HK2Main$HK2ServiceTrackerCustomizer", "removingService", "removing service = {0}, contract = {1}", new Object[]{service, contractName});
                }
            } else {
                Inhabitant inhabitant = this.habitat.getInhabitantByType(service.getClass());
                if (inhabitant != null) {
                    this.habitat.remove(inhabitant);
                } else {
                    Logger.logger.logp(Level.WARNING, "HK2Main$HK2ServiceTrackerCustomizer", "removedService", "cannot removed singleton service = {0}", service);
                }
            }
        }
    }

    private class NonHK2ServiceFilter
    implements Filter {
        private NonHK2ServiceFilter() {
        }

        public boolean match(ServiceReference serviceReference) {
            return !HK2Main.this.ctx.getBundle().equals(serviceReference.getBundle());
        }

        public boolean match(Dictionary dictionary) {
            throw new RuntimeException("Unexpected method called");
        }

        public boolean matchCase(Dictionary dictionary) {
            throw new RuntimeException("Unexpected method called");
        }

        public String toString() {
            return "(objectClass=*)";
        }
    }

    private class HabitatInfo {
        private Habitat habitat;
        private ServiceRegistration habitatRegistration;
        private ServiceTracker osgiServiceTracker;
        private ServiceRegistration moduleStartupRegistration;

        private HabitatInfo() {
        }
    }
}

