/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.MasterPassword;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-password-alias")
@Scoped(value=PerLookup.class)
@I18n(value="create.password.alias")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class CreatePasswordAlias
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreatePasswordAlias.class);
    @Param(name="aliasname", primary=true)
    private String aliasName;
    @Param(name="aliaspassword", password=true)
    private String aliasPassword;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject(name="Security SSL Password Provider Service")
    private MasterPassword masterPasswordHelper;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PasswordAdapter pa = this.masterPasswordHelper.getMasterPasswordAdapter();
            if (pa.getPasswordForAlias(this.aliasName) != null) {
                report.setMessage(localStrings.getLocalString("create.password.alias.alreadyexists", "Password alias with the specified name already exists. Please use the update-password-alias command to change it", new Object[]{this.aliasName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            pa.setPasswordForAlias(this.aliasName, this.aliasPassword.getBytes());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            report.setMessage(localStrings.getLocalString("create.password.alias.fail", "Creation of Password Alias {0} failed", new Object[]{this.aliasName}) + "  " + ex.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(localStrings.getLocalString("create.password.alias.success", "Encrypted password for the alias name {0} stored successfully", new Object[]{this.aliasName}));
    }
}

