/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class ApplicationHandlers {
    public static void getDeployedAppsInfo(HandlerContext handlerCtx) {
        String serverName = (String)handlerCtx.getInputValue("serverName");
        Map appPropsMap = (Map)handlerCtx.getInputValue("appPropsMap");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        TreeSet<String> filters = new TreeSet<String>();
        filters.add("");
        if (GuiUtil.isEmpty(filterValue)) {
            filterValue = null;
        }
        ArrayList result = new ArrayList();
        for (String oneAppName : appPropsMap.keySet()) {
            String engines = (String)appPropsMap.get(oneAppName);
            if (GuiUtil.isEmpty(engines)) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("name", oneAppName);
            oneRow.put("selected", false);
            oneRow.put("enableURL", DeployUtil.getTargetEnableInfo(oneAppName, true));
            oneRow.put("sniffers", engines);
            List sniffersList = GuiUtil.parseStringList(engines, ",");
            oneRow.put("sniffersList", sniffersList);
            for (int ix = 0; ix < sniffersList.size(); ++ix) {
                filters.add((String)sniffersList.get(ix));
            }
            if (filterValue != null && !sniffersList.contains(filterValue)) continue;
            ApplicationHandlers.getLaunchInfo(serverName, oneAppName, oneRow);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("filters", new ArrayList(filters));
    }

    private static void getLaunchInfo(String serverName, String appName, Map oneRow) {
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/applications/application/" + appName + ".json";
        String contextRoot = (String)RestApiHandlers.restRequest(endpoint, null, "GET", null).get("contextRoot");
        if (contextRoot == null) {
            contextRoot = "";
        }
        String refEndpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + serverName + "/application-ref/" + appName + ".json";
        String status = (String)RestApiHandlers.restRequest(endpoint, null, "GET", null).get("enabled");
        boolean enabled = Boolean.parseBoolean(status);
        oneRow.put("contextRoot", contextRoot);
        oneRow.put("hasLaunch", false);
        if (!enabled || contextRoot.equals("")) {
            return;
        }
    }

    public static void getConfigName(HandlerContext handlerCtx) {
        List clusters;
        String target = (String)handlerCtx.getInputValue("target");
        String endpoint = (String)GuiUtil.getSessionValue("REST_URL");
        endpoint = target.equals("server") ? endpoint + "/servers/server/server" : ((clusters = TargetUtil.getClusters()).contains(target) ? endpoint + "/clusters/cluster/" + target : endpoint + "/servers/server/" + target);
        handlerCtx.setOutputValue("configName", RestApiHandlers.getAttributesMap(endpoint).get("ConfigRef"));
    }

    public static void getApplicationTarget(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        handlerCtx.setOutputValue("result", (Object)DeployUtil.getApplicationTarget(appName));
    }

    public static void changeTargetStatus(HandlerContext handlerCtx) {
        String Enabled = (String)handlerCtx.getInputValue("Enabled");
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        boolean forLB = (Boolean)handlerCtx.getInputValue("forLB");
        String prefix = (String)GuiUtil.getSessionValue("REST_URL");
        for (Map oneRow : selectedRows) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            String endpoint = (String)oneRow.get("endpoint");
            if (forLB) {
                attrs.put("LbEnabled", Enabled);
            } else {
                attrs.put("Enabled", Enabled);
            }
            RestApiHandlers.restRequest(prefix + endpoint, attrs, "post", handlerCtx);
        }
    }

    public static void changeAppTargets(HandlerContext handlerCtx) {
        String endpoint;
        String appName = (String)handlerCtx.getInputValue("appName");
        String[] selTargets = (String[])handlerCtx.getInputValue("targets");
        List<String> selectedTargets = Arrays.asList(selTargets);
        List clusters = TargetUtil.getClusters();
        List standalone = TargetUtil.getStandaloneInstances();
        String clusterEndpoint = GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/";
        String serverEndpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
        standalone.add("server");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("ref", appName);
        List associatedTargets = DeployUtil.getApplicationTarget(appName);
        for (String newTarget : selectedTargets) {
            if (associatedTargets.contains(newTarget)) {
                associatedTargets.remove(newTarget);
                continue;
            }
            endpoint = clusters.contains(newTarget) ? clusterEndpoint + newTarget + "/application-ref" : serverEndpoint + newTarget + "/application-ref";
            RestApiHandlers.restRequest(endpoint, attrs, "post", handlerCtx);
        }
        for (String oTarget : associatedTargets) {
            endpoint = clusters.contains(oTarget) ? clusterEndpoint + oTarget : serverEndpoint + oTarget;
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            attrMap.put("target", oTarget);
            RestApiHandlers.restRequest(endpoint + "/application-ref/" + appName, attrMap, "delete", handlerCtx);
        }
    }

    public static void reloadApplication(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        if (DeployUtil.reloadApplication(appName, handlerCtx)) {
            GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("org.glassfish.web.admingui.Strings", "restart.successPE"), null);
        }
    }

    public static void getTargetEnableInfo(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        handlerCtx.setOutputValue("status", (Object)DeployUtil.getTargetEnableInfo(appName, false));
    }

    public static void getVsForDeployment(HandlerContext handlerCtx) {
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/server-config/http-service/virtual-server";
        List<Object> vsList = new ArrayList();
        try {
            vsList = RestApiHandlers.getChildrenNames(endpoint, "id");
            vsList.remove("__asadmin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        handlerCtx.setOutputValue("result", vsList);
    }

    public static void getTargetListInfo(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String prefix = (String)GuiUtil.getSessionValue("REST_URL");
        List clusters = TargetUtil.getClusters();
        List standalone = TargetUtil.getStandaloneInstances();
        standalone.add("server");
        List targetList = DeployUtil.getApplicationTarget(appName);
        ArrayList result = new ArrayList();
        Map attrs = null;
        String endpoint = "";
        for (String oneTarget : targetList) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            if (clusters.contains(oneTarget)) {
                endpoint = "/clusters/cluster/" + oneTarget + "/application-ref/" + appName;
                attrs = RestApiHandlers.getAttributesMap(prefix + endpoint);
            } else {
                endpoint = "/servers/server/" + oneTarget + "/application-ref/" + appName;
                attrs = RestApiHandlers.getAttributesMap(prefix + endpoint);
            }
            oneRow.put("selected", false);
            oneRow.put("endpoint", endpoint);
            oneRow.put("targetName", oneTarget);
            oneRow.put("enabled", attrs.get("Enabled"));
            oneRow.put("lbEnabled", attrs.get("LbEnabled"));
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    private static String calContextRoot(String contextRoot) {
        String ctxRoot = "";
        ctxRoot = contextRoot == null || contextRoot.equals("") || contextRoot.equals("/") ? "/" : (contextRoot.startsWith("/") ? contextRoot : "/" + contextRoot);
        return ctxRoot;
    }
}

