/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.spi.Target;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;

public class DeployUtil {
    private static final String COMMON_BUNDLE = "org.glassfish.common.admingui.Strings";

    public static void deploy(String[] targets, Properties deploymentProps, String location, HandlerContext handlerCtx) throws Exception {
        deploymentProps.setProperty("upload", "false");
        boolean status = DeployUtil.invokeDeploymentFacility(targets, deploymentProps, location, handlerCtx);
        if (status) {
            // empty if block
        }
    }

    public static boolean invokeDeploymentFacility(String[] targets, Properties props, String archivePath, HandlerContext handlerCtx) throws Exception {
        if (archivePath == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.deploy.nullArchiveError"));
        }
        if (targets == null) {
            String defaultTarget = "domain";
            targets = new String[]{defaultTarget};
        }
        File filePath = new File(archivePath);
        URI source = filePath.toURI();
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        DFProgressObject progressObject = null;
        progressObject = df.deploy(df.createTargets(targets), source, null, (Map)props);
        progressObject.waitFor();
        DFDeploymentStatus status = progressObject.getCompletedStatus();
        boolean ret = DeployUtil.checkDeployStatus(status, handlerCtx, true);
        return ret;
    }

    public static boolean checkDeployStatus(DFDeploymentStatus status, HandlerContext handlerCtx, boolean stopProcessing) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        DFDeploymentStatus.parseDeploymentStatus((DFDeploymentStatus)status, (PrintWriter)pw);
        byte[] statusBytes = bos.toByteArray();
        String statusString = new String(statusBytes);
        if (status != null && status.getStatus() == DFDeploymentStatus.Status.FAILURE) {
            if (stopProcessing) {
                GuiUtil.handleError(handlerCtx, statusString);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), statusString);
            }
            return false;
        }
        if (status != null && status.getStatus() == DFDeploymentStatus.Status.WARNING) {
            GuiUtil.prepareAlert(handlerCtx, "warning", GuiUtil.getMessage("deploy.warning"), statusString);
            return false;
        }
        return true;
    }

    public static void handleAppRefs(String appName, String[] targetNames, HandlerContext handlerCtx, boolean addFlag, Boolean enableFlag) {
        if (targetNames != null && targetNames.length > 0) {
            DeploymentFacility df = GuiUtil.getDeploymentFacility();
            DFProgressObject progressObject = null;
            Properties dProps = new Properties();
            if (enableFlag != null) {
                dProps.setProperty("enabled", enableFlag.toString());
            }
            progressObject = addFlag ? df.createAppRef(df.createTargets(targetNames), appName, (Map)dProps) : df.deleteAppRef(df.createTargets(targetNames), appName, (Map)dProps);
            DFDeploymentStatus status = df.waitFor(progressObject);
            DeployUtil.checkDeployStatus(status, handlerCtx, true);
        }
    }

    public static boolean reloadApplication(String appName, HandlerContext handlerCtx) {
        if (DeployUtil.enableApp(appName, handlerCtx, false)) {
            return DeployUtil.enableApp(appName, handlerCtx, true);
        }
        return false;
    }

    public static boolean enableApp(String appName, HandlerContext handlerCtx, boolean enable) {
        String[] targetNames = new String[]{"server"};
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        Target[] targets = df.createTargets(targetNames);
        DFProgressObject progressObject = enable ? df.enable(targets, appName) : df.disable(targets, appName);
        progressObject.waitFor();
        DFDeploymentStatus status = progressObject.getCompletedStatus();
        boolean ret = DeployUtil.checkDeployStatus(status, handlerCtx, false);
        return ret;
    }

    public static List getApplicationTarget(String appName) {
        ArrayList<String> targets = new ArrayList<String>();
        try {
            List<String> clusters = RestApiHandlers.getChildrenNames(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster", "Name");
            for (String oneCluster : clusters) {
                List<String> appRefs = RestApiHandlers.getChildrenNames(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + oneCluster + "/application-ref", "Ref");
                if (!appRefs.contains(appName)) continue;
                targets.add(oneCluster);
            }
            List servers = TargetUtil.getStandaloneInstances();
            servers.add("server");
            for (String oneServer : servers) {
                List<String> appRefs = RestApiHandlers.getChildrenNames(GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + oneServer + "/application-ref", "Ref");
                if (!appRefs.contains(appName)) continue;
                targets.add(oneServer);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return targets;
    }

    public static String getTargetEnableInfo(String appName, boolean useImage) {
        String prefix = (String)GuiUtil.getSessionValue("REST_URL");
        List clusters = TargetUtil.getClusters();
        List standalone = TargetUtil.getStandaloneInstances();
        String enabled = "true";
        int numEnabled = 0;
        int numDisabled = 0;
        if (clusters.isEmpty() && standalone.isEmpty()) {
            enabled = (String)RestApiHandlers.getAttributesMap(prefix + "/servers/server/server/application-ref/" + appName).get("Enabled");
            if (useImage) {
                return Boolean.parseBoolean(enabled) ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
            }
            return enabled;
        }
        standalone.add("server");
        List targetList = DeployUtil.getApplicationTarget(appName);
        for (String oneTarget : targetList) {
            enabled = clusters.contains(oneTarget) ? (String)RestApiHandlers.getAttributesMap(prefix + "/clusters/cluster/" + oneTarget + "/application-ref/" + appName).get("Enabled") : (String)RestApiHandlers.getAttributesMap(prefix + "/servers/server/" + oneTarget + "/application-ref/" + appName).get("Enabled");
            if (Boolean.parseBoolean(enabled)) {
                ++numEnabled;
                continue;
            }
            ++numDisabled;
        }
        int numTargets = targetList.size();
        if (numEnabled == numTargets) {
            return GuiUtil.getMessage("deploy.allEnabled");
        }
        if (numDisabled == numTargets) {
            return GuiUtil.getMessage("deploy.allDisabled");
        }
        return GuiUtil.getMessage("deploy.someEnabled", new String[]{"" + numEnabled});
    }
}

