/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupFilenameManager;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.BackupRestoreManager;
import com.sun.enterprise.backup.Status;
import com.sun.enterprise.backup.StringHelper;
import com.sun.enterprise.backup.util.FileUtils;
import com.sun.enterprise.backup.util.ZipFile;
import java.io.File;
import java.io.IOException;

public class RestoreManager
extends BackupRestoreManager {
    private static final String OLD_DOMAIN_SUFFIX = "_beforeRestore_";
    private File tempRestoreDir;
    private File backupDir;

    public RestoreManager(BackupRequest req) throws BackupException {
        super(req);
    }

    public String restore() throws BackupException {
        try {
            this.checkDomainName();
            ZipFile zf = new ZipFile(this.request.backupFile, this.tempRestoreDir);
            zf.explode();
            this.sanityCheckExplodedFiles();
            this.copyBackups();
            this.atomicSwap();
            this.setPermissions();
            String mesg = this.readAndDeletePropsFile();
            return mesg;
        }
        catch (BackupException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BackupException("Restore Error", e);
        }
    }

    void init() throws BackupException {
        super.init();
        if (this.request.backupFile == null) {
            this.initWithNoSpecifiedBackupFile();
        } else {
            this.initWithSpecifiedBackupFile();
        }
        this.tempRestoreDir = new File(this.request.domainsDir, this.request.domainName + "_" + System.currentTimeMillis());
    }

    private void initWithSpecifiedBackupFile() throws BackupException {
        if (this.request.backupFile.length() <= 0L) {
            throw new BackupException("backup-res.CorruptBackupFile", this.request.backupFile);
        }
        if (this.request.domainName == null) {
            if (!this.request.force) {
                throw new BackupException("backup-res.UseForceOption");
            }
            Status status = new Status();
            status.read(this.request.backupFile);
            this.request.domainName = status.getDomainName();
            this.request.domainDir = new File(this.request.domainsDir, this.request.domainName);
        }
        if (!FileUtils.safeIsDirectory(this.request.domainDir)) {
            this.request.domainDir.mkdirs();
        }
        this.backupDir = new File(this.request.domainDir, "backups");
        if (!FileUtils.safeIsDirectory(this.backupDir)) {
            this.backupDir = null;
        }
    }

    private void initWithNoSpecifiedBackupFile() throws BackupException {
        if (!FileUtils.safeIsDirectory(this.request.domainDir)) {
            throw new BackupException("backup-res.NoDomainDir", this.request.domainDir);
        }
        this.backupDir = new File(this.request.domainDir, "backups");
        if (!FileUtils.safeIsDirectory(this.backupDir)) {
            throw new BackupException("backup-res.NoBackupDir", this.backupDir);
        }
        BackupFilenameManager bfmgr = new BackupFilenameManager(this.backupDir, this.request.domainName);
        this.request.backupFile = bfmgr.latest();
    }

    private void copyBackups() throws IOException {
        if (this.backupDir != null) {
            File tempRestoreDirBackups = new File(this.tempRestoreDir, "backups");
            FileUtils.copyTree(this.backupDir, tempRestoreDirBackups);
        }
    }

    private void atomicSwap() throws BackupException {
        File oldDomain = new File(this.request.domainsDir, this.request.domainName + OLD_DOMAIN_SUFFIX + System.currentTimeMillis());
        if (!this.request.domainDir.renameTo(oldDomain)) {
            FileUtils.whack(this.tempRestoreDir);
            throw new BackupException("backup-res.CantRenameOriginalDomain", this.request.domainDir);
        }
        if (!this.tempRestoreDir.renameTo(this.request.domainDir)) {
            oldDomain.renameTo(this.request.domainDir);
            FileUtils.whack(this.tempRestoreDir);
            throw new BackupException("backup-res.CantRenameRestoredDomain");
        }
        FileUtils.whack(oldDomain);
    }

    private String readAndDeletePropsFile() {
        File propsFile = new File(this.request.domainDir, "backup.properties");
        Status status = new Status();
        String mesg = StringHelper.get("backup-res.SuccessfulRestore", this.request.domainName, this.request.domainDir);
        if (!this.request.terse) {
            mesg = mesg + "\n" + status.read(propsFile, false);
        }
        if (!propsFile.delete()) {
            propsFile.deleteOnExit();
        }
        return mesg;
    }

    private void setPermissions() {
        File backups = new File(this.request.domainDir, "backups");
        File bin = new File(this.request.domainDir, "bin");
        File config = new File(this.request.domainDir, "config");
        File webtmp = new File(this.request.domainDir, "generated/tmp");
        File masterPassword = new File(this.request.domainDir, "master-password");
        FileUtils.makeExecutable(bin);
        FileUtils.protect(backups);
        FileUtils.protect(config);
        FileUtils.protect(masterPassword);
        FileUtils.protect(webtmp);
    }

    private void sanityCheckExplodedFiles() throws BackupException {
        File statusFile = new File(this.tempRestoreDir, "backup.properties");
        if (!statusFile.exists()) {
            FileUtils.whack(this.tempRestoreDir);
            throw new BackupException("backup-res.RestoreError.CorruptBackupFile.NoStatusFile", this.request.domainName);
        }
    }

    private void checkDomainName() throws BackupException {
        Status status = new Status();
        status.read(this.request.backupFile);
        String buDomainName = status.getDomainName();
        if (buDomainName == null) {
            throw new BackupException(StringHelper.get("backup-res.CorruptBackupFile", this.request.backupFile));
        }
        if (!this.request.domainName.equals(buDomainName) && !this.request.force) {
            throw new BackupException(StringHelper.get("backup-res.DomainNameDifferentWarning", buDomainName, this.request.domainName));
        }
    }
}

