/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.LogMessages;
import com.sun.grizzly.websockets.ClientNetworkHandler;
import com.sun.grizzly.websockets.ClientWebSocket;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketConnectTask;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientWebSocketApplication
extends WebSocketApplication {
    static final Logger logger = Logger.getLogger("websocket");
    private final Selector selector;
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final Queue<ClientNetworkHandler> handlers = new ConcurrentLinkedQueue<ClientNetworkHandler>();
    private final Thread selectorThread;
    protected volatile long selectTimeout = 1000L;

    public ClientWebSocketApplication() throws IOException {
        this.selector = SelectorProvider.provider().openSelector();
        this.selectorThread = new Thread(new Runnable(){

            public void run() {
                ClientWebSocketApplication.this.select();
            }
        });
        this.selectorThread.setDaemon(true);
    }

    @Override
    public WebSocket createSocket(NetworkHandler handler, WebSocketListener ... listeners) throws IOException {
        return new ClientWebSocket(handler, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<WebSocket> connect(String address, WebSocketListener ... listeners) throws IOException {
        Thread thread = this.selectorThread;
        synchronized (thread) {
            if (!this.selectorThread.isAlive()) {
                this.selectorThread.start();
            }
        }
        WebSocketConnectTask command = new WebSocketConnectTask(this, address, listeners);
        this.executorService.execute(command);
        return command;
    }

    public void stop() throws IOException {
        if (this.running.getAndSet(false)) {
            for (WebSocket socket : this.getWebSockets()) {
                socket.close();
            }
        }
    }

    public void register(ClientNetworkHandler handler) {
        this.handlers.add(handler);
        this.selector.wakeup();
    }

    private void select() {
        while (this.running.get()) {
            try {
                while (!this.handlers.isEmpty()) {
                    ClientNetworkHandler handler = this.handlers.poll();
                    SocketChannel socketChannel = handler.getChannel();
                    if (socketChannel.isConnected()) {
                        socketChannel.register(this.getSelector(), 1, handler);
                        handler.doConnect(false);
                        continue;
                    }
                    socketChannel.register(this.getSelector(), 8, handler);
                }
                int count = this.selector.select(this.selectTimeout);
                if (count == 0) continue;
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    ClientNetworkHandler handler = (ClientNetworkHandler)key.attachment();
                    try {
                        handler.process(key);
                    }
                    catch (IOException e) {
                        handler.shutdown();
                    }
                }
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_WS_SELECT_ERROR((Object)e.getMessage()), e);
            }
        }
    }

    public void execute(Runnable runnable) {
        this.executorService.execute(runnable);
    }

    public Selector getSelector() {
        return this.selector;
    }

    protected long getSelectTimeout() {
        return this.selectTimeout;
    }

    protected void setSelectTimeout(long selectTimeout) {
        this.selectTimeout = selectTimeout;
    }
}

