/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.LoadResponseCommand;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationIOUtils;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;
import org.shoal.ha.cache.impl.util.Utility;

public class LoadRequestCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.touch");
    private K key;
    CommandResponse resp;
    private Future future;
    private long tokenId;
    private String originatingInstance;

    public LoadRequestCommand() {
        this(null);
    }

    public LoadRequestCommand(K key) {
        super((byte)35);
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    @Override
    protected LoadRequestCommand<K, V> createNewInstance() {
        return new LoadRequestCommand<K, V>();
    }

    @Override
    public void writeCommandPayload(DataStoreContext<K, V> trans, ReplicationOutputStream ros) throws IOException {
        ros.write(Utility.longToBytes(this.resp.getTokenId()));
        int keyLen = ReplicationIOUtils.writeLengthPrefixedKey(this.key, trans.getDataStoreKeyHelper(), ros);
        ReplicationIOUtils.writeLengthPrefixedString(ros, this.originatingInstance);
        trans.getDataStoreKeyHelper().writeKey(ros, this.key);
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, trans.getInstanceName() + " sending load " + this.key + " to " + this.getTargetName());
        }
    }

    @Override
    public void readCommandPayload(DataStoreContext<K, V> trans, byte[] data, int offset) throws IOException {
        this.tokenId = Utility.bytesToLong(data, offset);
        ReplicationIOUtils.KeyInfo<K> keyInfo = ReplicationIOUtils.readLengthPrefixedKey(trans.getDataStoreKeyHelper(), data, offset + 8);
        this.key = keyInfo.key;
        this.originatingInstance = ReplicationIOUtils.readLengthPrefixedString(data, offset + 8 + 4 + keyInfo.keyLen);
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, trans.getInstanceName() + " received load " + this.key + " from " + this.originatingInstance);
        }
    }

    @Override
    protected void prepareToTransmit(DataStoreContext<K, V> ctx) {
        this.originatingInstance = ctx.getInstanceName();
        String targetName = ctx.getKeyMapper().findReplicaInstance(ctx.getGroupName(), this.key);
        this.setTargetName(targetName);
        ResponseMediator respMed = ctx.getResponseMediator();
        this.resp = respMed.createCommandResponse();
        this.future = this.resp.getFuture();
    }

    @Override
    public void execute(DataStoreContext<K, V> ctx) {
        try {
            DataStoreEntry<K, V> e = ctx.getReplicaStore().get(this.key);
            if (!this.originatingInstance.equals(ctx.getInstanceName())) {
                LoadResponseCommand<K, V> rsp = new LoadResponseCommand<K, V>(this.key, e, this.tokenId);
                rsp.setOriginatingInstance(this.originatingInstance);
                this.getCommandManager().execute(rsp);
            } else {
                this.resp.setResult(e);
            }
        }
        catch (DataStoreException dsEx) {
            this.resp.setException(dsEx);
        }
    }

    public DataStoreEntry<K, V> getResult() throws DataStoreException {
        try {
            Object result = this.future.get(8000L, TimeUnit.MILLISECONDS);
            if (result instanceof Exception) {
                throw new DataStoreException((Exception)result);
            }
            return (DataStoreEntry)result;
        }
        catch (DataStoreException dsEx) {
            throw dsEx;
        }
        catch (InterruptedException inEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand Interrupted while waiting for result", inEx);
            throw new DataStoreException(inEx);
        }
        catch (TimeoutException timeoutEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand timed out while waiting for result", timeoutEx);
            throw new DataStoreException(timeoutEx);
        }
        catch (ExecutionException exeEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand got an exception while waiting for result", exeEx);
            throw new DataStoreException(exeEx);
        }
    }
}

