/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.Utility;

public class SaveCommand<K, V>
extends Command<K, V> {
    private K k;
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private V v;

    public SaveCommand() {
        super((byte)33);
    }

    public SaveCommand(K k, V v) {
        this();
        this.setKey(k);
        this.setValue(v);
    }

    public void setKey(K k) {
        this.k = k;
    }

    public void setValue(V v) {
        this.v = v;
    }

    @Override
    protected SaveCommand<K, V> createNewInstance() {
        return new SaveCommand<K, V>();
    }

    @Override
    protected void prepareToTransmit(DataStoreContext<K, V> ctx) {
        this.setTargetName(ctx.getKeyMapper().getMappedInstance(ctx.getGroupName(), this.k));
    }

    @Override
    public void writeCommandPayload(DataStoreContext<K, V> ctx, ReplicationOutputStream bos) throws IOException {
        int keyLenMark = bos.mark();
        bos.write(Utility.intToBytes(0));
        ctx.getDataStoreKeyHelper().writeKey(bos, this.k);
        int valueOffset = bos.mark() - keyLenMark;
        bos.reWrite(keyLenMark, Utility.intToBytes(valueOffset));
        ctx.getDataStoreEntryHelper().writeObject(bos, this.v);
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, ctx.getInstanceName() + " sending save " + this.k + " to " + this.getTargetName());
        }
    }

    @Override
    public void readCommandPayload(DataStoreContext<K, V> ctx, byte[] data, int offset) throws IOException {
        int valueOffset = Utility.bytesToInt(data, offset);
        this.k = ctx.getDataStoreKeyHelper().readKey(data, offset + 4);
        this.v = ctx.getDataStoreEntryHelper().readObject(data, offset + valueOffset);
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, ctx.getInstanceName() + " received save " + this.k + " from " + this.getTargetName());
        }
    }

    @Override
    public void execute(DataStoreContext<K, V> ctx) throws DataStoreException {
        ctx.getReplicaStore().put(this.k, this.v);
    }

    @Override
    public void postTransmit(String target, boolean status) {
        super.postTransmit(target, status);
    }
}

