/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.io.Serializable;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryEvaluator;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.command.LoadRequestCommand;
import org.shoal.ha.cache.impl.command.LoadResponseCommand;
import org.shoal.ha.cache.impl.command.RemoveCommand;
import org.shoal.ha.cache.impl.command.SaveCommand;
import org.shoal.ha.cache.impl.command.TouchCommand;
import org.shoal.ha.cache.impl.command.UpdateDeltaCommand;
import org.shoal.ha.cache.impl.interceptor.CommandMonitorInterceptor;
import org.shoal.ha.cache.impl.interceptor.TransmitInterceptor;
import org.shoal.ha.cache.impl.store.ReplicaLocationHolder;
import org.shoal.ha.cache.impl.store.ReplicaStore;
import org.shoal.ha.cache.impl.util.DefaultKeyMapper;
import org.shoal.ha.group.GroupService;
import org.shoal.ha.mapper.KeyMapper;

public class ReplicatedDataStore<K, V>
implements DataStore<K, V> {
    private String storeName;
    private String instanceName;
    private String groupName;
    private GroupService gs;
    private CommandManager<K, V> cm;
    private DataStoreEntryHelper<K, V> transformer;
    private DataStoreContext<K, V> dsc;
    private DataStoreConfigurator<K, V> conf;
    private ReplicaLocationHolder<K, V> localDS;

    public ReplicatedDataStore(DataStoreConfigurator<K, V> conf, GroupService gs) {
        this.conf = conf;
        this.storeName = conf.getStoreName();
        this.gs = gs;
        this.instanceName = gs.getMemberName();
        this.groupName = gs.getGroupName();
        this.initialize(conf);
    }

    private void initialize(DataStoreConfigurator<K, V> conf) {
        this.dsc = new DataStoreContext(this.storeName, this.gs, conf.getClassLoader());
        this.transformer = conf.getDataStoreEntryHelper();
        this.dsc.setDataStoreEntryHelper(this.transformer);
        this.dsc.setDataStoreKeyHelper(conf.getDataStoreKeyHelper());
        this.dsc.setKeyMapper(conf.getKeyMapper());
        this.cm = this.dsc.getCommandManager();
        this.cm.registerExecutionInterceptor(new CommandMonitorInterceptor());
        this.cm.registerExecutionInterceptor(new TransmitInterceptor());
        this.cm.registerCommand(new SaveCommand());
        this.cm.registerCommand(new LoadRequestCommand());
        this.cm.registerCommand(new LoadResponseCommand(null, null, 0L));
        this.cm.registerCommand(new RemoveCommand());
        this.cm.registerCommand(new TouchCommand());
        KeyMapper keyMapper = conf.getKeyMapper();
        if (keyMapper != null && keyMapper instanceof DefaultKeyMapper) {
            this.gs.registerGroupMemberEventListener((DefaultKeyMapper)keyMapper);
        }
        this.gs.registerGroupMessageReceiver(this.storeName, this.cm);
        this.localDS = new ReplicaLocationHolder<K, V>(conf, this.dsc);
        Logger logger = Logger.getLogger("org.shoal.ha.cache.config");
        logger.log(Level.INFO, "Created ReplicatedDataStore with config: " + conf);
    }

    public DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    @Override
    public String put(K k, V v) throws DataStoreException {
        SaveCommand<K, V> cmd = new SaveCommand<K, V>(k, v);
        this.cm.execute(cmd);
        String newLocation = cmd.getTargetName();
        this.localDS.put(k, v, newLocation);
        return newLocation;
    }

    @Override
    public String updateDelta(K k, Serializable obj) throws DataStoreException {
        UpdateDeltaCommand cmd = new UpdateDeltaCommand(k, obj);
        this.cm.execute(cmd);
        return cmd.getTargetName();
    }

    @Override
    public V get(K k) throws DataStoreException {
        V v = this.localDS.get(k);
        if (v == null) {
            ReplicaStore<K, V> replicaStore = this.dsc.getReplicaStore();
            DataStoreEntry<K, V> entry = replicaStore.get(k);
            if (entry == null) {
                LoadRequestCommand cmd = new LoadRequestCommand(k);
                this.cm.execute(cmd);
                entry = cmd.getResult();
            }
            if (entry != null) {
                v = this.transformer.getV(entry);
            }
        }
        return v;
    }

    @Override
    public void remove(K k) throws DataStoreException {
        this.localDS.remove(k);
        RemoveCommand cmd = new RemoveCommand();
        cmd.setKey(k);
        this.cm.execute(cmd);
    }

    @Override
    public String touch(K k, long version, long ts, long ttl) throws DataStoreException {
        TouchCommand tc = new TouchCommand(k, version, ts, ttl);
        String newLocation = tc.getTargetName();
        this.localDS.touch(k, version, ts, ttl, newLocation);
        return newLocation;
    }

    @Override
    public int removeIdleEntries(long idleFor) {
        return 0;
    }

    @Override
    public Collection find(DataStoreEntryEvaluator<K, V> kvDataStoreEntryEvaluator) {
        return null;
    }

    @Override
    public void update(DataStoreEntryEvaluator<K, V> kvDataStoreEntryEvaluator) {
    }

    @Override
    public void close() {
    }
}

