/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMap<K, V>
implements Serializable {
    private final Map<K, List<V>> store;
    private final boolean concurrencyControls;
    private static final MultiMap EMPTY = new MultiMap(Collections.emptyMap());

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        String newline = System.getProperty("line.separator");
        builder.append("{");
        for (K key : this.store.keySet()) {
            builder.append(key).append(": ");
            builder.append(this.store.get(key));
            builder.append(newline);
        }
        builder.append("}");
        return builder.toString();
    }

    public MultiMap() {
        this(new HashMap(), Habitat.CONCURRENCY_CONTROLS_DEFAULT);
    }

    MultiMap(Map<K, List<V>> store) {
        this(store, Habitat.CONCURRENCY_CONTROLS_DEFAULT);
    }

    MultiMap(boolean concurrencyControls) {
        this(new HashMap(), concurrencyControls);
    }

    protected MultiMap(Map<K, List<V>> store, boolean concurrencyControls) {
        this.store = store;
        this.concurrencyControls = concurrencyControls;
    }

    public MultiMap(MultiMap<K, V> base) {
        this();
        for (Map.Entry<K, List<V>> e : base.entrySet()) {
            this.store.put(e.getKey(), this.newList((Collection)e.getValue()));
        }
    }

    protected List<V> newList(Collection<? extends V> initialVals) {
        if (this.concurrencyControls) {
            if (null == initialVals) {
                return new CopyOnWriteArrayList();
            }
            return new CopyOnWriteArrayList<V>(initialVals);
        }
        if (null == initialVals) {
            return new ArrayList(1);
        }
        return new ArrayList<V>(initialVals);
    }

    public final void add(K k, V v) {
        List<V> l = this.store.get(k);
        if (l == null) {
            l = this.newList(null);
            this.store.put(k, l);
        }
        l.add(v);
    }

    public void set(K k, Collection<? extends V> v) {
        this.store.put(k, this.newList(v));
    }

    public void set(K k, V v) {
        List<V> vlist = this.newList(null);
        vlist.add(v);
        this.store.put(k, vlist);
    }

    public final List<V> get(K k) {
        List<V> l = this.store.get(k);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    final List<V> _get(K k) {
        List<V> l = this.store.get(k);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    public boolean containsKey(K k) {
        return !this.get(k).isEmpty();
    }

    public List<V> remove(K key) {
        return this.store.remove(key);
    }

    public boolean remove(K key, V entry) {
        List<V> list = this.store.get(key);
        return null == list ? false : list.remove(entry);
    }

    public final V getOne(K k) {
        List<V> lst = this.store.get(k);
        if (lst == null) {
            return null;
        }
        if (lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.store.entrySet();
    }

    public String toCommaSeparatedString() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<K, List<V>> e : this.entrySet()) {
            for (V v : e.getValue()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(e.getKey()).append('=').append(v);
            }
        }
        return buf.toString();
    }

    public MultiMap<K, V> clone() {
        return new MultiMap<K, V>(this);
    }

    public int size() {
        return this.store.size();
    }

    public static <K, V> MultiMap<K, V> emptyMap() {
        return EMPTY;
    }
}

