/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.universal.process.LocalAdminCommand;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.io.InstanceDirs;
import com.sun.enterprise.v3.admin.cluster.SecureAdminBootstrapHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.cluster.ssh.connect.RemoteConnectHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="create-instance")
@I18n(value="create.instance")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class CreateInstanceCommand
implements AdminCommand,
PostConstruct {
    private static final String DEFAULT_NODE = "localhost";
    private static final String LOCAL_HOST = "localhost";
    private static final String NL = System.getProperty("line.separator");
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodeList;
    @Inject
    private Nodes nodes;
    @Inject
    private ServerEnvironment env;
    @Param(name="node", alias="nodeagent")
    String node;
    @Param(name="config", optional=true)
    String configRef;
    @Param(name="cluster", optional=true)
    String clusterName;
    @Param(name="lbenabled", optional=true, defaultValue="true")
    private Boolean lbEnabled;
    @Param(name="checkports", optional=true, defaultValue="true")
    private boolean checkPorts;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    @Param(name="instance_name", primary=true)
    private String instance;
    private Logger logger;
    private AdminCommandContext ctx;
    private RemoteInstanceCommandHelper helper;
    private RemoteConnectHelper rch;
    private Node theNode = null;
    private String nodeHost = null;
    private String nodeDir = null;
    private String installDir = null;
    private int dasPort;
    private String dasHost;
    private StringBuilder humanVersionOfCommand = new StringBuilder();

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.ctx = context;
        this.logger = context.logger;
        this.theNode = this.nodes.getNode(this.node);
        if (this.theNode == null) {
            String msg = Strings.get("noSuchNode", this.node);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.nodeHost = this.getHostFromNodeName(this.node, this.theNode);
        this.nodeDir = this.theNode.getNodeDir();
        this.installDir = this.theNode.getInstallDir();
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_register-instance", report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"node", (Object)this.node);
        map.add((Object)"config", (Object)this.configRef);
        map.add((Object)"cluster", (Object)this.clusterName);
        if (this.lbEnabled != null) {
            map.add((Object)"lbenabled", (Object)this.lbEnabled.toString());
        }
        if (!this.checkPorts) {
            map.add((Object)"checkports", (Object)"false");
        }
        map.add((Object)"systemproperties", (Object)this.systemProperties);
        map.add((Object)"DEFAULT", (Object)this.instance);
        ci.parameters(map);
        ci.execute();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            return;
        }
        this.dasPort = this.helper.getAdminPort("server");
        this.dasHost = System.getProperty("com.sun.aas.hostName");
        this.rch = new RemoteConnectHelper(this.habitat, this.nodeList, this.logger, this.dasHost, this.dasPort);
        this.humanVersionOfCommand.append("asadmin --host " + this.dasHost + " --port " + this.dasPort + " create-local-instance " + " --node " + this.node);
        if (this.rch.isLocalhost(this.nodes.getNode(this.node))) {
            LocalAdminCommand lac = null;
            if (this.nodeDir == null) {
                lac = new LocalAdminCommand("_create-instance-filesystem", new String[]{"--node", this.node, this.instance});
            } else {
                lac = new LocalAdminCommand("_create-instance-filesystem", new String[]{"--node", this.node, "--nodedir", this.nodeDir, this.instance});
                this.humanVersionOfCommand.append(" --nodedir " + this.nodeDir);
            }
            this.humanVersionOfCommand.append(" " + this.instance);
            String msg = Strings.get("creatingInstance", this.instance, "localhost");
            this.logger.info(msg);
            try {
                int status = lac.execute();
                if (status != 0) {
                    msg = Strings.get("nonzero.status", "asadmin _create-instance-filesystem", "localhost");
                    this.logger.warning(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                }
                this.bootstrapSecureAdminLocally();
            }
            catch (ProcessManagerException ex) {
                msg = Strings.get("create.instance.filesystem.failed", this.instance, this.node, this.nodeHost);
                this.logger.warning(msg);
                String msg2 = Strings.get("node.command.failed", this.node, this.nodeHost, "_create-instance-filesystem", ex.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg + NL + msg2);
                return;
            }
        } else if (this.rch.isRemoteConnectRequired(this.node)) {
            String msg = Strings.get("creatingInstance", this.instance, this.node);
            this.logger.info(msg);
            this.createInstanceRemote();
            int status = this.createInstanceRemote();
            if (status == 0) {
                this.bootstrapSecureAdminRemotely();
            }
        } else {
            String msg = Strings.get("create.instance.filesystem.failed", this.instance, this.node, this.nodeHost);
            this.logger.warning(msg);
            String msg2 = Strings.get("node.not.ssh", this.node, this.nodeHost);
            this.logger.warning(msg2);
            String msg3 = Strings.get("node.ssh.tocomplete", this.nodeHost, this.installDir, this.humanVersionOfCommand);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg + NL + msg2 + NL + NL + msg3);
            return;
        }
    }

    private String getHostFromNodeName(String nodeName, Node theNode) {
        String hostName = null;
        if (theNode != null) {
            hostName = theNode.getNodeHost();
        }
        if (hostName == null && nodeName.equals("localhost")) {
            return "localhost";
        }
        return hostName;
    }

    private File getLocalInstanceDir() throws IOException {
        File nodeDirFile = this.nodeDir != null ? new File(this.nodeDir) : this.defaultNodeDirFile();
        InstanceDirs instanceDirs = new InstanceDirs(nodeDirFile.getParent(), nodeDirFile.getName(), this.instance);
        return instanceDirs.getInstanceDir();
    }

    private File defaultNodeDirFile() {
        return new File(new File(this.installDir, "nodes"), this.node);
    }

    private File getDomainInstanceDir() {
        return this.env.getInstanceRoot();
    }

    private int createInstanceRemote() {
        ActionReport report = this.ctx.getActionReport();
        StringBuilder output = new StringBuilder();
        ParameterMap map = new ParameterMap();
        map.set((Object)"--node", (Object)this.node);
        if (this.nodeDir != null) {
            map.set((Object)"--nodedir", (Object)this.nodeDir);
            this.humanVersionOfCommand.append(" --nodedir " + this.nodeDir);
        }
        map.set((Object)"DEFAULT", (Object)this.instance);
        this.humanVersionOfCommand.append(" " + this.instance);
        try {
            int status = this.rch.runCommand(this.node, "_create-instance-filesystem", map, output);
            if (output.length() > 0) {
                this.logger.info(output.toString());
            }
            if (status != 0) {
                String msg1 = Strings.get("create.instance.filesystem.failed", this.instance, this.node, this.nodeHost);
                this.logger.warning(msg1);
                String msg2 = Strings.get("node.command.failed", this.node, this.nodeHost, output.toString(), this.rch.getLastCommandRun());
                this.logger.warning(msg2);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg1 + NL + msg2);
                return 1;
            }
        }
        catch (SSHCommandExecutionException ec) {
            String msg1 = Strings.get("create.instance.filesystem.failed", this.instance, this.node, this.nodeHost);
            String msg2 = Strings.get("node.ssh.bad.connect", this.node, this.nodeHost, ec.getMessage());
            String msg3 = Strings.get("node.ssh.tocomplete", this.nodeHost, this.installDir, this.humanVersionOfCommand);
            report.setMessage(msg1 + " " + msg2 + NL + NL + msg3);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            msg1 = Strings.get("node.command.failed.ssh.details", this.node, this.nodeHost, ec.getCommandRun(), ec.getMessage(), ec.getSSHSettings());
            this.logger.warning(msg1);
            return 1;
        }
        return 0;
    }

    private int bootstrapSecureAdminLocally() {
        ActionReport report = this.ctx.getActionReport();
        try {
            SecureAdminBootstrapHelper bootHelper = SecureAdminBootstrapHelper.getLocalHelper(this.env.getInstanceRoot(), this.getLocalInstanceDir());
            bootHelper.bootstrapInstance();
            return 0;
        }
        catch (Exception ex) {
            String msg = Strings.get("create.instance.local.boot.failed", this.instance, this.node, this.nodeHost);
            this.logger.severe(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return 1;
        }
    }

    private int bootstrapSecureAdminRemotely() {
        ActionReport report = this.ctx.getActionReport();
        try {
            SecureAdminBootstrapHelper bootHelper = SecureAdminBootstrapHelper.getRemoteHelper(this.habitat, this.getDomainInstanceDir(), this.nodeDir, this.instance, this.chooseNode(this.nodeList, this.node), this.logger);
            bootHelper.bootstrapInstance();
            return 0;
        }
        catch (Exception ex) {
            String msg = Strings.get("create.instance.remote.boot.failed", this.instance, ex instanceof SecureAdminBootstrapHelper.BootstrapException ? ((SecureAdminBootstrapHelper.BootstrapException)ex).sshSettings() : null, ex.getMessage(), this.nodeHost);
            this.logger.severe(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return 1;
        }
    }

    private Node chooseNode(Node[] nodes, String nodeName) {
        for (Node n : nodes) {
            if (!n.getName().equals(nodeName)) continue;
            return n;
        }
        throw new IllegalArgumentException(nodeName);
    }
}

