/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.common.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import java.util.logging.Level;

public class FailureRecoverySignalImpl
extends FailureNotificationSignalImpl
implements FailureRecoverySignal {
    private String componentName;

    public FailureRecoverySignalImpl(String componentName, String failedMember, String groupName, long startTime) {
        this.failedMember = failedMember;
        this.componentName = componentName;
        this.groupName = groupName;
        this.startTime = startTime;
        this.ctx = GMSContextFactory.getGMSContext(groupName);
    }

    FailureRecoverySignalImpl(FailureRecoverySignal signal) {
        this.failedMember = signal.getMemberToken();
        this.componentName = signal.getComponentName();
        this.groupName = signal.getGroupName();
        this.startTime = signal.getStartTime();
        this.ctx = GMSContextFactory.getGMSContext(this.groupName);
    }

    @Override
    public void acquire() throws SignalAcquireException {
        try {
            GroupHandle gh = this.ctx.getGroupHandle();
            if (gh.isMemberAlive(this.failedMember)) {
                throw new GMSException("Cannot raise fence on " + this.failedMember + " as it is already alive");
            }
            gh.raiseFence(this.componentName, this.failedMember);
            logger.log(Level.FINE, "raised fence for component " + this.componentName + " and member " + this.failedMember);
        }
        catch (GMSException e) {
            throw new SignalAcquireException((Exception)((Object)e));
        }
    }

    @Override
    public void release() throws SignalReleaseException {
        try {
            GMSContextFactory.getGMSContext(this.groupName).getGroupHandle().lowerFence(this.componentName, this.failedMember);
            logger.log(Level.FINE, "lowered fence for component " + this.componentName + " and member " + this.failedMember);
            this.failedMember = null;
        }
        catch (GMSException e) {
            throw new SignalReleaseException((Exception)((Object)e));
        }
    }

    public String getComponentName() {
        return this.componentName;
    }
}

