/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.GMSCacheable;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.impl.base.GMSContextImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GroupManagementServiceImpl
implements GroupManagementService,
Runnable {
    private GMSContext ctx;
    private Router router;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";

    public GroupManagementServiceImpl(String serverToken, String groupName, GroupManagementService.MemberType membertype, Properties properties) {
        this.initialize(serverToken, groupName, membertype, properties);
    }

    public GroupManagementServiceImpl() {
    }

    public void initialize(String serverToken, String groupName, GroupManagementService.MemberType membertype, Properties properties) {
        if (this.initialized.compareAndSet(false, true)) {
            this.ctx = GMSContextFactory.produceGMSContext(serverToken, groupName, membertype, properties);
            this.router = this.ctx.getRouter();
        }
    }

    @Override
    public void run() {
        this.startup();
    }

    private void startup() {
        try {
            logger.log(Level.INFO, "gms.joinMessage");
            this.join();
        }
        catch (GMSException e) {
            logger.log(Level.FINE, "gms.joinException", e);
        }
    }

    public void addActionFactory(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.router.addDestination(failureNotificationActionFactory);
    }

    public void addActionFactory(String componentName, FailureRecoveryActionFactory failureRecoveryActionFactory) {
        this.router.addDestination(componentName, failureRecoveryActionFactory);
    }

    public void addActionFactory(JoinedAndReadyNotificationActionFactory joinedAndReadyNotificationActionFactory) {
        this.router.addDestination(joinedAndReadyNotificationActionFactory);
    }

    public void addActionFactory(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.router.addDestination(joinNotificationActionFactory);
    }

    public void addActionFactory(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.router.addDestination(plannedShutdownActionFactory);
    }

    public void addActionFactory(MessageActionFactory messageActionFactory, String componentName) {
        this.router.addDestination(messageActionFactory, componentName);
    }

    public void addActionFactory(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.router.addDestination(failureSuspectedActionFactory);
    }

    public void addActionFactory(GroupLeadershipNotificationActionFactory groupLeadershipNotificationActionFactory) {
        this.router.addDestination(groupLeadershipNotificationActionFactory);
    }

    public void removeActionFactory(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.router.removeDestination(failureNotificationActionFactory);
    }

    public void removeFailureRecoveryActionFactory(String componentName) {
        this.router.removeFailureRecoveryAFDestination(componentName);
    }

    public void removeFailureSuspectedActionFactory(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.router.removeDestination(failureSuspectedActionFactory);
    }

    public void removeActionFactory(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.router.removeDestination(joinNotificationActionFactory);
    }

    public void removeActionFactory(JoinedAndReadyNotificationActionFactory joinedAndReadyNotificationActionFactory) {
        this.router.removeDestination(joinedAndReadyNotificationActionFactory);
    }

    public void removeActionFactory(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.router.removeDestination(plannedShutdownActionFactory);
    }

    public void removeMessageActionFactory(String componentName) {
        this.router.removeMessageAFDestination(componentName);
    }

    public void removeActionFactory(GroupLeadershipNotificationActionFactory groupLeadershipNotificationActionFactory) {
        this.router.removeDestination(groupLeadershipNotificationActionFactory);
    }

    public GroupHandle getGroupHandle() {
        return this.ctx.getGroupHandle();
    }

    public void shutdown(GMSConstants.shutdownType shutdownType2) {
        this.leave(shutdownType2);
    }

    public void updateMemberDetails(String memberToken, Serializable key, Serializable value) throws GMSException {
        if (this.isWatchdog()) {
            return;
        }
        this.ctx.getDistributedStateCache().addToCache(MEMBER_DETAILS, memberToken, key, value);
    }

    public Map<Serializable, Serializable> getMemberDetails(String memberToken) {
        if (this.isWatchdog()) {
            HashMap<Serializable, Serializable> retval = new HashMap<Serializable, Serializable>();
            return retval;
        }
        return this.ctx.getDistributedStateCache().getFromCacheForPattern(MEMBER_DETAILS, memberToken);
    }

    public Map<Serializable, Serializable> getAllMemberDetails(Serializable key) {
        HashMap<Serializable, Serializable> retval = new HashMap<Serializable, Serializable>();
        if (this.isWatchdog()) {
            return retval;
        }
        Map ret = this.ctx.getDistributedStateCache().getFromCache((Object)key);
        for (GMSCacheable c : ret.keySet()) {
            if (!c.getComponentName().equals(MEMBER_DETAILS)) continue;
            retval.put((Serializable)((Object)c.getMemberTokenId()), (Serializable)ret.get(c));
        }
        return retval;
    }

    public String getGroupName() {
        if (this.isWatchdog()) {
            return "";
        }
        return this.ctx.getGroupName();
    }

    public GroupManagementService.MemberType getMemberType() {
        return this.ctx.getMemberType();
    }

    public String getInstanceName() {
        return this.ctx.getServerIdentityToken();
    }

    public void setMemberDetails(String serverToken, Map<? extends Object, ? extends Object> keyValuePairs) throws GMSException {
        if (this.isWatchdog()) {
            return;
        }
        for (Object object : keyValuePairs.keySet()) {
            this.ctx.getDistributedStateCache().addToLocalCache(MEMBER_DETAILS, serverToken, (Serializable)object, (Serializable)keyValuePairs.get(object));
        }
    }

    public void join() throws GMSException {
        logger.log(Level.FINE, "Connecting to group......");
        this.ctx.join();
    }

    private void leave(GMSConstants.shutdownType shutdownType2) {
        logger.log(Level.FINE, "Deregistering ActionFactory instances...");
        this.removeAllActionFactories();
        this.ctx.leave(shutdownType2);
        GMSContextFactory.removeGMSContext(this.ctx.getGroupName());
    }

    private void removeAllActionFactories() {
        this.router.undocketAllDestinations();
    }

    public void announceGroupShutdown(String groupName, GMSConstants.shutdownState shutdownState2) {
        GMSContext gctx = GMSContextFactory.getGMSContext(groupName);
        logger.log(Level.INFO, "GMS:Announcing GroupShutdown to group " + groupName + " with State = " + shutdownState2);
        gctx.announceGroupShutdown(groupName, shutdownState2);
    }

    public void announceGroupStartup(String groupName, GMSConstants.groupStartupState startupState, List<String> memberTokens) {
        GMSContext gctx = GMSContextFactory.getGMSContext(groupName);
        StringBuffer sb = new StringBuffer(160);
        sb.append("GMS:Announcing GroupStartup[").append(startupState.toString()).append("] for Group:").append(groupName).append(" Members: ");
        if (memberTokens != null) {
            for (String memberToken : memberTokens) {
                sb.append(memberToken).append(",");
            }
        }
        logger.log(Level.INFO, sb.toString());
        gctx.announceGroupStartup(groupName, startupState, memberTokens);
    }

    public void reportJoinedAndReadyState(String groupName) {
        GMSContext gctx = GMSContextFactory.getGMSContext(groupName);
        logger.log(Level.INFO, "GMS:Reporting Joined and Ready state to group " + groupName);
        gctx.getGroupCommunicationProvider().reportJoinedAndReadyState();
        logger.log(Level.FINE, "GMS : JoinedAndReady state reported to group " + groupName);
    }

    public boolean isGroupBeingShutdown(String groupName) {
        return this.ctx.isGroupBeingShutdown(groupName);
    }

    public void announceWatchdogObservedFailure(String serverToken) throws GMSException {
        if (!this.isWatchdog()) {
            throw new GMSException("illegal state: announceWatchdogObservedFailure operation is only valid for a WATCHDOG member.");
        }
        GroupHandle gh = this.ctx.getGroupHandle();
        this.ctx.getGroupCommunicationProvider().announceWatchdogObservedFailure(serverToken);
    }

    private boolean isWatchdog() {
        return this.ctx.getMemberType() == GroupManagementService.MemberType.WATCHDOG;
    }

    public int outstandingNotifications() {
        return ((GMSContextImpl)this.ctx).outstandingNotifications();
    }
}

