/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.gms.tools;

import com.sun.enterprise.gms.tools.StringManager;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class MulticastSenderThread
extends Thread {
    static final StringManager sm = StringManager.getInstance();
    int mcPort;
    String mcAddress;
    String bindInterface;
    long msgPeriodInMillis;
    boolean debug;
    String dataString;

    public MulticastSenderThread(int mcPort, String mcAddress, String bindInterface, long msgPeriodInMillis, boolean debug, String dataString) {
        super("McastSender");
        this.mcPort = mcPort;
        this.mcAddress = mcAddress;
        this.bindInterface = bindInterface;
        this.msgPeriodInMillis = msgPeriodInMillis;
        this.debug = debug;
        this.dataString = dataString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block16: {
            DatagramSocket socket;
            InetAddress group;
            block17: {
                group = null;
                socket = null;
                byte[] data = this.dataString.getBytes();
                group = InetAddress.getByName(this.mcAddress);
                DatagramPacket datagramPacket = new DatagramPacket(data, data.length, group, this.mcPort);
                socket = new MulticastSocket(this.mcPort);
                if (this.bindInterface != null) {
                    ((MulticastSocket)socket).setInterface(InetAddress.getByName(this.bindInterface));
                }
                ((MulticastSocket)socket).setLoopbackMode(false);
                this.log(String.format("joining group: %s", group.toString()));
                ((MulticastSocket)socket).joinGroup(group);
                System.out.println(sm.get("sending.message", this.dataString, this.msgPeriodInMillis));
                while (!MulticastSenderThread.interrupted()) {
                    socket.send(datagramPacket);
                    try {
                        Thread.sleep(this.msgPeriodInMillis);
                    }
                    catch (InterruptedException ie) {
                        this.log("interrupted");
                        break;
                    }
                }
                if (socket == null) break block16;
                if (group == null) break block17;
                this.log("socket leaving group");
                try {
                    ((MulticastSocket)socket).leaveGroup(group);
                }
                catch (IOException ioe) {
                    System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                }
            }
            this.log("closing socket");
            socket.close();
            break block16;
            catch (Exception e) {
                block18: {
                    try {
                        System.err.println(sm.get("whoops", e.toString()));
                        if (socket == null) break block16;
                        if (group == null) break block18;
                        this.log("socket leaving group");
                    }
                    catch (Throwable throwable) {
                        if (socket != null) {
                            if (group != null) {
                                this.log("socket leaving group");
                                try {
                                    ((MulticastSocket)socket).leaveGroup(group);
                                }
                                catch (IOException ioe) {
                                    System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                                }
                            }
                            this.log("closing socket");
                            socket.close();
                        }
                        throw throwable;
                    }
                    try {
                        ((MulticastSocket)socket).leaveGroup(group);
                    }
                    catch (IOException ioe) {
                        System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                    }
                }
                this.log("closing socket");
                socket.close();
            }
        }
    }

    private void log(String msg) {
        if (this.debug) {
            System.err.println(String.format("%s: %s", this.getName(), msg));
        }
    }
}

