/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.grizzly.tcp.Adapter;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.appclient.server.core.AppClientDeployer;
import org.glassfish.appclient.server.core.AppClientServerApplication;
import org.glassfish.appclient.server.core.jws.AppClientHTTPAdapter;
import org.glassfish.appclient.server.core.jws.ExtensionFileManager;
import org.glassfish.appclient.server.core.jws.JavaWebStartInfo;
import org.glassfish.appclient.server.core.jws.NamingConventions;
import org.glassfish.appclient.server.core.jws.Util;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.AutoSignedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.SimpleDynamicContentImpl;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class JWSAdapterManager
implements PostConstruct {
    private static final String SIGNING_ALIAS_PROPERTY_NAME = "jar-signing-alias";
    private static final String DEFAULT_SIGNING_ALIAS = "s1as";
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ServerContext serverContext;
    @Inject
    private RequestDispatcher requestDispatcher;
    @Inject
    private ASJarSigner jarSigner;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private ExtensionFileManager extensionFileManager;
    @Inject
    AppClientDeployer appClientDeployer;
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final List<String> DO_NOT_SERVE_LIST = Arrays.asList("glassfish/modules/jaxb-osgi.jar");
    private static final String JWS_SIGNED_SYSTEM_JARS_ROOT = "java-web-start/___system";
    private static final String JWS_SIGNED_DOMAIN_JARS_ROOT = "java-web-start/___domain";
    private static final String JAVA_WEB_START_CONTEXT_ROOT_PROPERTY_NAME = "javaWebStartContextRoot";
    private final Map<String, AutoSignedContent> appLevelSignedSystemContent = new HashMap<String, AutoSignedContent>();
    private URI installRootURI = null;
    private AppClientHTTPAdapter systemAdapter = null;
    private Logger logger = null;
    private IiopService iiopService;
    private final ConcurrentHashMap<String, Set<AppClientServerApplication>> contributingAppClients = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AppClientHTTPAdapter> httpAdapters = new ConcurrentHashMap();
    private URI umbrellaRootURI;
    private File umbrellaRoot;
    private File systemLevelSignedJARsRoot;
    private File domainLevelSignedJARsRoot;

    @Override
    public void postConstruct() {
        this.installRootURI = this.serverContext.getInstallRoot().toURI();
        this.logger = LogDomains.getLogger(AppClientDeployer.class, (String)"javax.enterprise.system.container.appclient");
        this.iiopService = this.config.getIiopService();
        this.umbrellaRoot = new File(this.installRootURI).getParentFile();
        this.umbrellaRootURI = this.umbrellaRoot.toURI();
        this.systemLevelSignedJARsRoot = new File(this.serverEnv.getDomainRoot(), JWS_SIGNED_SYSTEM_JARS_ROOT);
        this.domainLevelSignedJARsRoot = new File(this.serverEnv.getDomainRoot(), JWS_SIGNED_DOMAIN_JARS_ROOT);
    }

    public static String signingAlias(DeploymentContext dc) {
        return JWSAdapterManager.chooseAlias(dc);
    }

    File rootForSignedFilesInDomain() {
        return this.domainLevelSignedJARsRoot;
    }

    void addStaticSystemContent(String lookupURI, StaticContent newContent) throws IOException {
        this.systemAdapter().addContentIfAbsent(lookupURI, newContent);
    }

    private static String chooseAlias(DeploymentContext dc) {
        String userSpecifiedAlias = JWSAdapterManager.extractUserProvidedAlias(dc);
        return userSpecifiedAlias != null ? userSpecifiedAlias : DEFAULT_SIGNING_ALIAS;
    }

    private static String extractUserProvidedAlias(DeploymentContext dc) {
        return dc.getAppProps().getProperty(SIGNING_ALIAS_PROPERTY_NAME);
    }

    private AppClientHTTPAdapter startSystemContentAdapter() {
        try {
            AppClientHTTPAdapter sysAdapter = new AppClientHTTPAdapter("/___JWSappclient/___system", new Properties(), this.serverEnv.getDomainRoot(), new File(this.installRootURI), this.iiopService);
            this.requestDispatcher.registerEndpoint("/___JWSappclient/___system", (Adapter)sysAdapter, null);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Registered system content adapter serving " + (Object)((Object)sysAdapter));
            }
            return sysAdapter;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "enterprise.deployment.appclient.jws.errStartSystemAdapter", e);
            return null;
        }
    }

    void addContentIfAbsent(Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent) throws IOException {
        this.systemAdapter().addContentIfAbsent(staticContent, dynamicContent);
    }

    Map<String, StaticContent> addStaticSystemContent(List<String> systemJARRelativeURIs, String signingAlias) throws IOException {
        HashMap<String, StaticContent> result = new HashMap<String, StaticContent>();
        File gfClientJAR = this.gfClientJAR();
        String classPathExpr = this.getGFClientModuleClassPath(gfClientJAR);
        URI gfClientJARURI = gfClientJAR.toURI();
        result.put(this.systemPath(gfClientJARURI, signingAlias), this.systemJarSignedContent(gfClientJAR, signingAlias));
        for (String classPathElement : classPathExpr.split(" ")) {
            URI uri = gfClientJARURI.resolve(classPathElement);
            String systemPath = this.systemPath(uri, signingAlias);
            File candidateFile = new File(uri);
            String relativeSystemPath = this.relativeSystemPath(uri);
            if (!candidateFile.exists() || candidateFile.isDirectory() || DO_NOT_SERVE_LIST.contains(relativeSystemPath)) continue;
            result.put(systemPath, this.systemJarSignedContent(candidateFile, signingAlias));
            systemJARRelativeURIs.add(this.relativeSystemPath(uri));
        }
        File endorsedDir = new File(this.modulesDir(), "endorsed");
        for (File endorsedJar : endorsedDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".jar");
            }
        })) {
            result.put(this.systemPath(endorsedJar.toURI()), this.systemJarSignedContent(endorsedJar, signingAlias));
            systemJARRelativeURIs.add(this.relativeSystemPath(endorsedJar.toURI()));
        }
        return result;
    }

    File gfClientJAR() {
        return new File(this.modulesDir(), "gf-client.jar");
    }

    File gfClientModuleJAR() {
        return new File(this.modulesDir(), "gf-client-module.jar");
    }

    private File modulesDir() {
        return new File(new File(this.installRootURI), "modules");
    }

    static String publicExtensionHref(ExtensionFileManager.Extension ext) {
        return "/___JWSappclient/___system/" + JWSAdapterManager.publicExtensionLookupURIText(ext);
    }

    static String publicExtensionLookupURIText(ExtensionFileManager.Extension ext) {
        return "___ext/" + ext.getExtDirectoryNumber() + "/" + ext.getFile().getName();
    }

    private AutoSignedContent systemJarSignedContent(File unsignedFile, String signingAlias) throws FileNotFoundException {
        File signedFile = new File(this.signedSystemContentAliasDir(signingAlias), this.relativeSystemPath(unsignedFile.toURI()));
        return new AutoSignedContent(unsignedFile, signedFile, signingAlias, this.jarSigner);
    }

    Map<String, DynamicContent> addDynamicSystemContent(List<String> systemJARRelativeURIs, String signingAlias) throws IOException {
        HashMap<String, DynamicContent> result = new HashMap<String, DynamicContent>();
        String template = JavaWebStartInfo.textFromURL("/org/glassfish/appclient/server/core/jws/templates/systemJarsDocumentTemplate.jnlp");
        StringBuilder sb = new StringBuilder();
        for (String relativeURIString : systemJARRelativeURIs) {
            sb.append("<jar href=\"" + signingAlias + "/" + relativeURIString + "\"/>").append(LINE_SEP);
        }
        Properties p = new Properties();
        p.setProperty("system.jars", sb.toString());
        String replacedText = Util.replaceTokens(template, p);
        result.put(NamingConventions.systemJNLPURI(signingAlias), new SimpleDynamicContentImpl(replacedText, "jnlp"));
        return result;
    }

    private String systemPath(URI systemFileURI) {
        return this.relativeSystemPath(systemFileURI);
    }

    String systemPath(URI systemFileURI, String signingAlias) {
        return signingAlias + "/" + this.relativeSystemPath(systemFileURI);
    }

    String systemPathInClientJNLP(URI systemFileURI, String signingAlias) {
        return "${request.scheme}://${request.host}:${request.port}/___JWSappclient/___system/" + signingAlias + "/" + this.relativeSystemPath(systemFileURI);
    }

    private String relativeSystemPath(URI systemFileURI) {
        return this.umbrellaRootURI.relativize(systemFileURI).getPath();
    }

    public synchronized void addContentForAppClient(String appName, String clientURIWithinEAR, AppClientServerApplication contributor, Properties tokens, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent) throws EndpointRegistrationException, IOException {
        AppClientHTTPAdapter appAdapter = this.httpAdapters.get(appName);
        if (appAdapter == null) {
            appAdapter = this.addAppAdapter(appName, staticContent, dynamicContent, tokens, contributor);
        } else {
            appAdapter.addContentIfAbsent(staticContent, dynamicContent);
        }
        AppClientHTTPAdapter userFriendlyAppAdapter = this.addAdapterForUserFriendlyContextRoot(staticContent, dynamicContent, tokens, contributor);
        this.appClientDeployer.recordContextRoot(appName, clientURIWithinEAR, userFriendlyAppAdapter.contextRoot());
        this.logger.fine("Registered at context roots " + appAdapter.contextRoot() + "," + userFriendlyAppAdapter.contextRoot());
        this.addContributorToAppLevelAdapter(appName, contributor);
    }

    private AppClientHTTPAdapter createAndRegisterAdapter(String contextRoot, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, Properties tokens, AppClientServerApplication contributor) throws IOException, EndpointRegistrationException {
        AppClientHTTPAdapter adapter = new AppClientHTTPAdapter(contextRoot, staticContent, dynamicContent, tokens, this.serverEnv.getDomainRoot(), new File(this.installRootURI), this.iiopService);
        this.requestDispatcher.registerEndpoint(contextRoot, (Adapter)adapter, null);
        return adapter;
    }

    private synchronized AppClientHTTPAdapter addAdapterForUserFriendlyContextRoot(Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, Properties tokens, AppClientServerApplication contributor) throws IOException, EndpointRegistrationException {
        String ufContextRoot = JWSAdapterManager.userFriendlyContextRoot(contributor);
        return this.createAndRegisterAdapter(ufContextRoot, staticContent, dynamicContent, tokens, contributor);
    }

    private synchronized AppClientHTTPAdapter systemAdapter() {
        if (this.systemAdapter == null) {
            this.systemAdapter = this.startSystemContentAdapter();
        }
        return this.systemAdapter;
    }

    private synchronized AppClientHTTPAdapter addAppAdapter(String appName, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, Properties tokens, AppClientServerApplication contributor) throws IOException, EndpointRegistrationException {
        this.systemAdapter();
        String contextRoot = NamingConventions.contextRootForAppAdapter(appName);
        AppClientHTTPAdapter adapter = this.createAndRegisterAdapter(contextRoot, staticContent, dynamicContent, tokens, contributor);
        this.httpAdapters.put(appName, adapter);
        return adapter;
    }

    static String userFriendlyContextRoot(AppClientServerApplication contributor) {
        return JWSAdapterManager.userFriendlyContextRoot(contributor.getDescriptor(), contributor.dc().getAppProps());
    }

    private static String userFriendlyContextRoot(ApplicationClientDescriptor acDesc, Properties p) {
        String ufContextRoot = NamingConventions.defaultUserFriendlyContextRoot(acDesc);
        String overridingContextRoot = null;
        if (acDesc.getApplication().isVirtual()) {
            overridingContextRoot = p.getProperty(JAVA_WEB_START_CONTEXT_ROOT_PROPERTY_NAME);
        } else {
            String uriToNestedClient = NamingConventions.uriToNestedClient(acDesc);
            overridingContextRoot = p.getProperty("javaWebStartContextRoot." + uriToNestedClient);
        }
        if (overridingContextRoot != null) {
            ufContextRoot = overridingContextRoot;
        }
        if (!ufContextRoot.startsWith("/")) {
            ufContextRoot = "/" + ufContextRoot;
        }
        return ufContextRoot;
    }

    public synchronized AutoSignedContent appLevelSignedSystemContent(String relativePathToSystemJar, String alias) throws FileNotFoundException {
        String key = JWSAdapterManager.keyToAppLevelSignedSystemContentMap(relativePathToSystemJar, alias);
        AutoSignedContent result = this.appLevelSignedSystemContent.get(key);
        if (result == null) {
            File unsignedFile = new File(this.umbrellaRoot, relativePathToSystemJar);
            File signedFile = new File(this.systemLevelSignedJARsRoot, key);
            result = new AutoSignedContent(unsignedFile, signedFile, alias, this.jarSigner);
            this.appLevelSignedSystemContent.put(key, result);
        }
        return result;
    }

    private static String keyToAppLevelSignedSystemContentMap(String relativePathToSystemJar, String alias) {
        return alias + "/" + relativePathToSystemJar;
    }

    File signedSystemContentAliasDir(String alias) {
        return new File(this.systemLevelSignedJARsRoot, alias);
    }

    public String contextRootForAppAdapter(String appName) {
        AppClientHTTPAdapter adapter = this.httpAdapters.get(appName);
        if (adapter != null) {
            return adapter.contextRoot();
        }
        return null;
    }

    private synchronized void addContributorToAppLevelAdapter(String appName, AppClientServerApplication contributor) {
        Set<AppClientServerApplication> contributorsToAppLevelAdapter = this.contributingAppClients.get(appName);
        if (contributorsToAppLevelAdapter == null) {
            contributorsToAppLevelAdapter = new HashSet<AppClientServerApplication>();
            this.contributingAppClients.put(appName, contributorsToAppLevelAdapter);
        }
        contributorsToAppLevelAdapter.add(contributor);
    }

    public synchronized void removeContentForAppClient(String appName, String clientURIWithinEAR, AppClientServerApplication contributor) throws EndpointRegistrationException {
        this.removeAdapter(JWSAdapterManager.userFriendlyContextRoot(contributor));
        this.removeContributorToAppLevelAdapter(appName, contributor);
        this.appClientDeployer.removeContextRoot(appName, clientURIWithinEAR);
    }

    private synchronized void removeContributorToAppLevelAdapter(String appName, AppClientServerApplication contributor) throws EndpointRegistrationException {
        Set<AppClientServerApplication> contributorsToAppLevelAdapter = this.contributingAppClients.get(appName);
        if (contributorsToAppLevelAdapter == null) {
            return;
        }
        contributorsToAppLevelAdapter.remove(contributor);
        if (contributorsToAppLevelAdapter.isEmpty()) {
            this.contributingAppClients.remove(appName);
            this.removeAdapter(NamingConventions.contextRootForAppAdapter(appName));
            this.httpAdapters.remove(appName);
        }
    }

    private synchronized void removeAdapter(String contextRoot) throws EndpointRegistrationException {
        this.requestDispatcher.unregisterEndpoint(contextRoot);
    }

    private String getGFClientModuleClassPath(File gfClientJAR) throws IOException {
        JarFile jf = new JarFile(gfClientJAR);
        Manifest mf = jf.getManifest();
        Attributes mainAttrs = mf.getMainAttributes();
        return mainAttrs.getValue(Attributes.Name.CLASS_PATH);
    }
}

