/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.InputBuffer;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.SelectedKeyAttachmentLogic;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.ClientHandShake;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.ServerHandShake;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketSelectionKeyAttachment;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerNetworkHandler
implements NetworkHandler {
    private final Request request;
    private final Response response;
    private final InputBuffer inputBuffer;
    private final InternalOutputBuffer outputBuffer;
    private final ByteChunk chunk = new ByteChunk();
    private WebSocket socket;
    private WebSocketSelectionKeyAttachment attachment;

    public ServerNetworkHandler(Request req, Response resp) {
        this.request = req;
        this.response = resp;
        this.inputBuffer = req.getInputBuffer();
        this.outputBuffer = (InternalOutputBuffer)resp.getOutputBuffer();
    }

    public ServerNetworkHandler(ProcessorTask task, AsyncProcessorTask async, Request req, Response resp) {
        this(req, resp);
        this.attachment = new WebSocketSelectionKeyAttachment(this, task, async);
    }

    public WebSocket getWebSocket() {
        return this.socket;
    }

    public void setWebSocket(BaseWebSocket webSocket) {
        this.socket = webSocket;
    }

    protected void handshake(boolean sslSupport) throws IOException, HandshakeException {
        boolean secure = "https".equalsIgnoreCase(this.request.scheme().toString()) || sslSupport;
        this.fill();
        ClientHandShake clientHS = new ClientHandShake(this.request, secure, this.chunk);
        ServerHandShake server = new ServerHandShake(clientHS.isSecure(), clientHS.getOrigin(), clientHS.getServerHostName(), clientHS.getPort(), clientHS.getResourcePath(), clientHS.getSubProtocol(), clientHS.getKey1(), clientHS.getKey2(), clientHS.getKey3());
        server.respond(this.response);
        this.socket.onConnect();
        if (this.chunk.getLength() > 0) {
            this.readFrame();
        }
    }

    protected void readFrame() throws IOException {
        this.fill();
        while (this.socket.isConnected() && this.chunk.getLength() != 0) {
            DataFrame dataFrame = DataFrame.read(this);
            if (dataFrame != null) {
                dataFrame.getType().respond(this.socket, dataFrame);
                continue;
            }
            this.socket.close();
        }
    }

    private void read() throws IOException {
        int count;
        ByteChunk bytes = new ByteChunk(8192);
        while ((count = this.inputBuffer.doRead(bytes, this.request)) == 8192) {
            this.chunk.append(bytes);
        }
        if (count > 0) {
            this.chunk.append(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte get() throws IOException {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            return (byte)this.chunk.substract();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peek(byte ... bytes) throws IOException {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            return this.chunk.startsWith(bytes);
        }
    }

    private void fill() throws IOException {
        if (this.chunk.getLength() == 0) {
            this.read();
        }
    }

    private void write(byte[] bytes) throws IOException {
        ByteChunk buffer = new ByteChunk(bytes.length);
        buffer.setBytes(bytes, 0, bytes.length);
        this.outputBuffer.doWrite(buffer, this.response);
        this.outputBuffer.flush();
    }

    public void send(DataFrame frame) throws IOException {
        this.write(frame.frame());
    }

    public HttpServletRequest getRequest() throws IOException {
        GrizzlyRequest r = new GrizzlyRequest();
        r.setRequest(this.request);
        return new WSServletRequestImpl(r);
    }

    public HttpServletResponse getResponse() throws IOException {
        GrizzlyResponse r = new GrizzlyResponse();
        r.setResponse(this.response);
        return new HttpServletResponseImpl(r);
    }

    public SelectedKeyAttachmentLogic getAttachment() {
        return this.attachment;
    }

    private static class WSServletRequestImpl
    extends HttpServletRequestImpl {
        public WSServletRequestImpl(GrizzlyRequest r) throws IOException {
            super(r);
            this.setContextImpl(new ServletContextImpl());
        }
    }
}

