/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store;

import java.io.Serializable;
import java.util.Map;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.shoal.adapter.store.RepliatedBackingStoreRegistry;
import org.shoal.adapter.store.ReplicatedBackingStoreFactory;
import org.shoal.adapter.store.commands.BroadcastLoadRequestCommand;
import org.shoal.adapter.store.commands.LoadRequestCommand;
import org.shoal.adapter.store.commands.LoadResponseCommand;
import org.shoal.adapter.store.commands.RemoveCommand;
import org.shoal.adapter.store.commands.SaveCommand;
import org.shoal.adapter.store.commands.StaleCopyRemoveCommand;
import org.shoal.adapter.store.commands.TouchCommand;
import org.shoal.adapter.store.commands.UpdateDeltaCommand;
import org.shoal.adapter.store.commands.monitor.ListBackingStoreConfigurationCommand;
import org.shoal.adapter.store.commands.monitor.ListBackingStoreConfigurationResponseCommand;
import org.shoal.adapter.store.commands.monitor.ListReplicaStoreEntriesCommand;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.DataStoreFactory;
import org.shoal.ha.cache.api.DefaultObjectInputOutputStreamFactory;
import org.shoal.ha.cache.impl.store.ReplicatedDataStore;
import org.shoal.ha.mapper.KeyMapper;

public class ReplicatedBackingStore<K extends Serializable, V extends Serializable>
extends BackingStore<K, V> {
    private DataStore<K, V> dataStore;
    private ReplicatedBackingStoreFactory factory;

    void setBackingStoreFactory(ReplicatedBackingStoreFactory factory) {
        this.factory = factory;
    }

    public DataStoreContext<K, V> getDataStoreContext() {
        return null;
    }

    public void initialize(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        ClassLoader cl;
        super.initialize(conf);
        DataStoreConfigurator dsConf = new DataStoreConfigurator();
        dsConf.setInstanceName(conf.getInstanceName()).setGroupName(conf.getClusterName()).setStoreName(conf.getStoreName()).setKeyClazz(conf.getKeyClazz()).setValueClazz(conf.getValueClazz());
        Map vendorSpecificMap = conf.getVendorSpecificSettings();
        Object stGMS = vendorSpecificMap.get("start.gms");
        boolean startGMS = false;
        if (stGMS != null) {
            if (stGMS instanceof String) {
                try {
                    startGMS = Boolean.valueOf((String)stGMS);
                }
                catch (Throwable th) {}
            } else if (stGMS instanceof Boolean) {
                startGMS = (Boolean)stGMS;
            }
        }
        Object cacheLocally = vendorSpecificMap.get("local.caching");
        boolean enableLocalCaching = false;
        if (cacheLocally != null) {
            if (cacheLocally instanceof String) {
                try {
                    enableLocalCaching = Boolean.valueOf((String)cacheLocally);
                }
                catch (Throwable th) {}
            } else if (cacheLocally instanceof Boolean) {
                enableLocalCaching = (Boolean)stGMS;
            }
        }
        if ((cl = (ClassLoader)vendorSpecificMap.get("class.loader")) == null) {
            cl = conf.getValueClazz().getClassLoader();
        }
        dsConf.setClassLoader(cl).setStartGMS(startGMS).setCacheLocally(enableLocalCaching);
        boolean asyncReplication = vendorSpecificMap.get("async.replication") == null ? true : (Boolean)vendorSpecificMap.get("async.replication");
        dsConf.setDoASyncReplication(asyncReplication);
        KeyMapper keyMapper = (KeyMapper)vendorSpecificMap.get("key.mapper");
        if (keyMapper != null) {
            dsConf.setKeyMapper(keyMapper);
        }
        dsConf.setObjectInputOutputStreamFactory(new DefaultObjectInputOutputStreamFactory());
        dsConf.addCommand(new SaveCommand());
        dsConf.addCommand(new RemoveCommand());
        dsConf.addCommand(new LoadRequestCommand());
        dsConf.addCommand(new BroadcastLoadRequestCommand());
        dsConf.addCommand(new LoadResponseCommand());
        dsConf.addCommand(new StaleCopyRemoveCommand());
        dsConf.addCommand(new TouchCommand());
        dsConf.addCommand(new UpdateDeltaCommand());
        dsConf.addCommand(new ListBackingStoreConfigurationCommand());
        dsConf.addCommand(new ListBackingStoreConfigurationResponseCommand());
        dsConf.addCommand(new ListReplicaStoreEntriesCommand(null));
        this.dataStore = DataStoreFactory.createDataStore(dsConf);
        RepliatedBackingStoreRegistry.registerStore(conf.getStoreName(), conf, ((ReplicatedDataStore)this.dataStore).getDataStoreContext());
    }

    public V load(K key, String cookie) throws BackingStoreException {
        try {
            System.out.println("***** =>  load(" + key + ", " + cookie + ")");
            return (V)((Serializable)this.dataStore.get(key, cookie));
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during load: " + key, (Throwable)dsEx);
        }
    }

    public String save(K key, V value, boolean isNew) throws BackingStoreException {
        try {
            return this.dataStore.put(key, value);
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during save: " + key, (Throwable)dsEx);
        }
    }

    public void remove(K key) throws BackingStoreException {
        try {
            this.dataStore.remove(key);
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during remove: " + key, (Throwable)dsEx);
        }
    }

    public int removeExpired(long idleTime) throws BackingStoreException {
        return 0;
    }

    public int size() throws BackingStoreException {
        return 0;
    }

    public void destroy() throws BackingStoreException {
        RepliatedBackingStoreRegistry.unregisterStore(super.getBackingStoreConfiguration().getStoreName());
        this.dataStore.close();
    }

    public void updateTimestamp(K key, long time) throws BackingStoreException {
        try {
            this.dataStore.touch(key, 0x7FFFFFFFFFFFFFFEL, time, 1800000L);
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during load: " + key, (Throwable)dsEx);
        }
    }
}

