/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store;

import java.io.Serializable;
import java.util.Properties;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.api.BackingStoreTransaction;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.adapter.store.ReplicatedBackingStore;
import org.shoal.adapter.store.StoreableReplicatedBackingStore;

public class ReplicatedBackingStoreFactory
implements BackingStoreFactory {
    private Properties props;

    public ReplicatedBackingStoreFactory() {
    }

    public ReplicatedBackingStoreFactory(Properties p) {
        this.props = p;
    }

    public <K extends Serializable, V extends Serializable> BackingStore<K, V> createBackingStore(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        Class vClazz = conf.getValueClazz();
        ReplicatedBackingStore<K, V> backingStore = null;
        if (Storeable.class.isAssignableFrom(vClazz)) {
            backingStore = this.createStoreableBackingStore(conf);
        } else {
            ReplicatedBackingStore<K, V> store = null;
            store = new ReplicatedBackingStore<K, V>();
            store.setBackingStoreFactory(this);
            store.initialize(conf);
            backingStore = store;
        }
        System.out.println("ReplicatedBackingStoreFactory:: CREATED an instance of: " + ((Object)backingStore).getClass().getName());
        return backingStore;
    }

    public BackingStoreTransaction createBackingStoreTransaction() {
        return new BackingStoreTransaction(){

            public void commit() throws BackingStoreException {
            }
        };
    }

    private BackingStore createStoreableBackingStore(BackingStoreConfiguration conf) throws BackingStoreException {
        StoreableReplicatedBackingStore backingStore = new StoreableReplicatedBackingStore();
        backingStore.setBackingStoreFactory(this);
        backingStore.initialize(conf);
        return backingStore;
    }
}

