/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.adapter.store.RepliatedBackingStoreRegistry;
import org.shoal.adapter.store.ReplicatedBackingStoreFactory;
import org.shoal.adapter.store.commands.StoreableBroadcastLoadRequestCommand;
import org.shoal.adapter.store.commands.StoreableFullSaveCommand;
import org.shoal.adapter.store.commands.StoreableLoadRequestCommand;
import org.shoal.adapter.store.commands.StoreableLoadResponseCommand;
import org.shoal.adapter.store.commands.StoreableRemoveCommand;
import org.shoal.adapter.store.commands.StoreableSaveCommand;
import org.shoal.adapter.store.commands.StoreableTouchCommand;
import org.shoal.adapter.store.commands.monitor.ListBackingStoreConfigurationCommand;
import org.shoal.adapter.store.commands.monitor.ListBackingStoreConfigurationResponseCommand;
import org.shoal.adapter.store.commands.monitor.ListReplicaStoreEntriesCommand;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.DefaultObjectInputOutputStreamFactory;
import org.shoal.ha.cache.api.ReplicationFramework;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.store.ReplicaStore;

public class StoreableReplicatedBackingStore<K extends Serializable, V extends Storeable>
extends BackingStore<K, V> {
    private ReplicationFramework<K, V> framework;
    private ReplicaStore<K, V> replicaStore;
    boolean localCachingEnabled;
    private ReplicatedBackingStoreFactory factory;

    void setBackingStoreFactory(ReplicatedBackingStoreFactory factory) {
        this.factory = factory;
    }

    public void initialize(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        ClassLoader cl;
        super.initialize(conf);
        DataStoreConfigurator dsConf = new DataStoreConfigurator();
        dsConf.setInstanceName(conf.getInstanceName()).setGroupName(conf.getClusterName()).setStoreName(conf.getStoreName()).setKeyClazz(conf.getKeyClazz()).setValueClazz(conf.getValueClazz());
        Map vendorSpecificMap = conf.getVendorSpecificSettings();
        Object stGMS = vendorSpecificMap.get("start.gms");
        boolean startGMS = false;
        if (stGMS != null) {
            if (stGMS instanceof String) {
                try {
                    startGMS = Boolean.valueOf((String)stGMS);
                }
                catch (Throwable th) {}
            } else if (stGMS instanceof Boolean) {
                startGMS = (Boolean)stGMS;
            }
        }
        Object cacheLocally = vendorSpecificMap.get("local.caching");
        boolean enableLocalCaching = false;
        if (cacheLocally != null) {
            if (cacheLocally instanceof String) {
                try {
                    enableLocalCaching = Boolean.valueOf((String)cacheLocally);
                }
                catch (Throwable th) {}
            } else if (cacheLocally instanceof Boolean) {
                enableLocalCaching = (Boolean)stGMS;
            }
        }
        if ((cl = (ClassLoader)vendorSpecificMap.get("class.loader")) == null) {
            cl = conf.getValueClazz().getClassLoader();
        }
        dsConf.setClassLoader(cl).setStartGMS(startGMS).setCacheLocally(enableLocalCaching);
        boolean asyncReplication = vendorSpecificMap.get("async.replication") == null ? true : (Boolean)vendorSpecificMap.get("async.replication");
        dsConf.setDoASyncReplication(asyncReplication);
        dsConf.setObjectInputOutputStreamFactory(new DefaultObjectInputOutputStreamFactory());
        dsConf.addCommand(new StoreableSaveCommand());
        dsConf.addCommand(new StoreableFullSaveCommand());
        dsConf.addCommand(new StoreableRemoveCommand());
        dsConf.addCommand(new StoreableTouchCommand());
        dsConf.addCommand(new StoreableLoadRequestCommand());
        dsConf.addCommand(new StoreableBroadcastLoadRequestCommand());
        dsConf.addCommand(new StoreableLoadResponseCommand());
        dsConf.addCommand(new StoreableRemoveCommand());
        dsConf.addCommand(new ListBackingStoreConfigurationCommand());
        dsConf.addCommand(new ListBackingStoreConfigurationResponseCommand());
        dsConf.addCommand(new ListReplicaStoreEntriesCommand(null));
        this.framework = new ReplicationFramework(dsConf);
        this.replicaStore = this.framework.getReplicaStore();
        this.localCachingEnabled = this.framework.getDataStoreConfigurator().isCacheLocally();
        RepliatedBackingStoreRegistry.registerStore(conf.getStoreName(), conf, this.framework.getDataStoreContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V load(K key, String cookie) throws BackingStoreException {
        System.out.println("Entered load(" + key + ", " + cookie + ")");
        DataStoreEntry<K, Storeable> entry = this.replicaStore.getOrCreateEntry(key);
        Long version = Long.MIN_VALUE;
        String[] requestHint = null;
        if (cookie != null) {
            requestHint = cookie.split(":");
            String verStr = requestHint[0];
            if (version != null) {
                version = Long.valueOf(verStr);
            }
        }
        Object v = null;
        DataStoreEntry<K, Storeable> dataStoreEntry = entry;
        synchronized (dataStoreEntry) {
            if (!entry.isRemoved()) {
                v = (Storeable)entry.getV();
                System.out.println("Entered load[1](" + key + ", " + cookie + ")" + "; v: " + v + "; v.version: " + (v != null ? Long.valueOf(v._storeable_getVersion()) : "null"));
                if (v == null || v._storeable_getVersion() < version) {
                    v = null;
                }
            } else {
                return null;
            }
        }
        if (v == null) {
            try {
                Command command;
                String respondingInstance = null;
                if (requestHint == null || requestHint.length <= 1) {
                    command = new StoreableBroadcastLoadRequestCommand(key, version);
                    this.framework.execute(command);
                    v = ((StoreableBroadcastLoadRequestCommand)command).getResult(3L, TimeUnit.SECONDS);
                    respondingInstance = ((StoreableBroadcastLoadRequestCommand)command).getRespondingInstanceName();
                } else {
                    command = new StoreableLoadRequestCommand(key, cookie);
                    this.framework.execute(command);
                    v = ((StoreableLoadRequestCommand)command).getResult(3L, TimeUnit.SECONDS);
                    respondingInstance = ((StoreableLoadRequestCommand)command).getRespondingInstanceName();
                }
                entry.setV((Storeable)v);
                DataStoreEntry<K, Storeable> dataStoreEntry2 = entry = this.replicaStore.getOrCreateEntry(key);
                synchronized (dataStoreEntry2) {
                    if (!entry.isRemoved()) {
                        entry.setReplicaInstanceName(respondingInstance);
                        if (this.localCachingEnabled) {
                            entry.setV((Storeable)v);
                        }
                    }
                }
            }
            catch (DataStoreException dseEx) {
                throw new BackingStoreException("Error during load", (Throwable)dseEx);
            }
        }
        return (V)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(K key, V value, boolean isNew) throws BackingStoreException {
        String result = null;
        try {
            DataStoreEntry<K, V> entry;
            DataStoreEntry<K, V> dataStoreEntry = entry = this.replicaStore.getOrCreateEntry(key);
            synchronized (dataStoreEntry) {
                StoreableSaveCommand<K, V> cmd = new StoreableSaveCommand<K, V>(key, value);
                cmd.setEntry(entry);
                this.framework.execute(cmd);
                if (!entry.isRemoved()) {
                    if (this.localCachingEnabled) {
                        entry.setV(value);
                    }
                    entry.setReplicaInstanceName(cmd.getTargetName());
                    result = cmd.getTargetName();
                }
                result = cmd.getKeyMappingInfo();
                System.out.println(" save cookie : " + result);
            }
            return result;
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during save: " + key, (Throwable)dsEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) throws BackingStoreException {
        try {
            DataStoreEntry<K, V> entry;
            DataStoreEntry<K, V> dataStoreEntry = entry = this.replicaStore.getOrCreateEntry(key);
            synchronized (dataStoreEntry) {
                entry.markAsRemoved("Removed by BackingStore.remove");
            }
            StoreableRemoveCommand cmd = new StoreableRemoveCommand(key);
            this.framework.execute(cmd);
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during remove: " + key, (Throwable)dsEx);
        }
    }

    public int removeExpired(long idleTime) throws BackingStoreException {
        return 0;
    }

    public int size() throws BackingStoreException {
        return this.framework.getReplicaStore().size();
    }

    public void destroy() throws BackingStoreException {
        this.framework = null;
    }

    public void updateTimestamp(K key, long t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateTimestamp(K key, Long version, Long accessTime, Long maxIdleTime) throws BackingStoreException {
        String result = "";
        try {
            DataStoreEntry<K, V> entry;
            DataStoreEntry<K, V> dataStoreEntry = entry = this.replicaStore.getOrCreateEntry(key);
            synchronized (dataStoreEntry) {
                if (!entry.isRemoved() && entry.getReplicaInstanceName() != null) {
                    StoreableTouchCommand cmd = new StoreableTouchCommand(key, version, accessTime, maxIdleTime);
                    this.framework.execute(cmd);
                    result = entry.getReplicaInstanceName().equals(cmd.getTargetName()) ? cmd.getTargetName() : "";
                }
            }
        }
        catch (DataStoreException dsEx) {
            throw new BackingStoreException("Error during load: " + key, (Throwable)dsEx);
        }
        return result;
    }

    public ReplicationFramework<K, V> getFramework() {
        return this.framework;
    }

    public DataStoreContext<K, V> getDataStoreContext() {
        return this.framework.getDataStoreContext();
    }
}

