/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class ReplicationFrame<K, V> {
    private String sourceInstanceName;
    private String targetInstanceName;
    private int seqNo;
    private List<Command<K, V>> commands = new LinkedList<Command<K, V>>();

    public ReplicationFrame(int seqNo, String sourceInstanceName) {
        this.seqNo = seqNo;
        this.sourceInstanceName = sourceInstanceName;
    }

    public String getSourceInstanceName() {
        return this.sourceInstanceName;
    }

    public String getTargetInstanceName() {
        return this.targetInstanceName;
    }

    public void setTargetInstanceName(String targetInstanceName) {
        this.targetInstanceName = targetInstanceName;
    }

    public int getSeqNo() {
        return this.seqNo;
    }

    public void setSeqNo(int seqNo) {
        this.seqNo = seqNo;
    }

    public void addCommand(Command<K, V> cmd) {
        this.commands.add(cmd);
    }

    public List<Command<K, V>> getCommands() {
        return this.commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSerializedData() {
        byte[] data = new byte[]{};
        ReplicationOutputStream bos = new ReplicationOutputStream();
        try {
            int i;
            bos.writeInt(this.seqNo);
            bos.writeLengthPrefixedString(this.sourceInstanceName);
            bos.writeLengthPrefixedString(this.targetInstanceName);
            int cmdSz = this.commands.size();
            bos.writeInt(cmdSz);
            int[] cmdOffsets = new int[cmdSz];
            int offMark = bos.mark();
            for (int i2 = 0; i2 < cmdSz; ++i2) {
                bos.writeInt(0);
            }
            int cmdDataMark = bos.size();
            for (i = 0; i < cmdSz; ++i) {
                cmdOffsets[i] = bos.mark();
                bos.writeInt(0);
                Command<K, V> cmd = this.commands.get(i);
                cmd.write(bos);
                int len = bos.size() - cmdOffsets[i] - 4;
                bos.moveTo(cmdOffsets[i]);
                bos.writeInt(len);
                bos.backToAppendMode();
            }
            bos.moveTo(offMark);
            for (i = 0; i < cmdSz; ++i) {
                bos.writeInt(cmdOffsets[i]);
            }
            bos.backToAppendMode();
            bos.flush();
            data = bos.toByteArray();
            System.out.println("Wrote " + cmdSz + " commands; totalBytes: " + data.length);
        }
        catch (IOException ioEx) {
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception ex) {}
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> ReplicationFrame<K, V> toReplicationFrame(DataStoreContext<K, V> dsc, ReplicationInputStream ris) {
        ReplicationFrame<K, V> frame = null;
        int frameOffset = ris.mark();
        int seqNo = ris.readInt();
        String srcName = ris.readLengthPrefixedString();
        String tarName = ris.readLengthPrefixedString();
        frame = new ReplicationFrame<K, V>(seqNo, srcName);
        frame.setTargetInstanceName(tarName);
        int numStates = ris.readInt();
        int[] cmdOffsets = new int[numStates];
        for (int i = 0; i < numStates; ++i) {
            cmdOffsets[i] = ris.readInt();
        }
        CommandManager<K, V> cm = dsc.getCommandManager();
        for (int i = 0; i < numStates; ++i) {
            ris.skipTo(cmdOffsets[i] + frameOffset);
            byte[] cmdData = ris.readLengthPrefixedBytes();
            ByteArrayInputStream cmdRIS = null;
            try {
                Command<K, V> cmd = cm.createNewInstance(cmdData[0]);
                cmdRIS = new ReplicationInputStream(cmdData);
                cmd.prepareToExecute((ReplicationInputStream)cmdRIS);
                frame.addCommand(cmd);
                continue;
            }
            catch (IOException dse) {
                dse.printStackTrace();
                continue;
            }
            finally {
                try {
                    cmdRIS.close();
                }
                catch (Exception ex) {}
            }
        }
        return frame;
    }

    public String toString() {
        return "ReplicationFrame{sourceInstanceName='" + this.sourceInstanceName + '\'' + ", targetInstanceName='" + this.targetInstanceName + '\'' + ", seqNo=" + this.seqNo + ", state.size=" + this.commands.size() + '}';
    }
}

