/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.ha.store.api.StoreEntryProcessor;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;

public class ReplicaStore<K, V> {
    private DataStoreContext<K, V> ctx;
    private ConcurrentHashMap<K, DataStoreEntry<K, V>> map = new ConcurrentHashMap();

    public ReplicaStore(DataStoreContext<K, V> ctx) {
        this.ctx = ctx;
    }

    public DataStoreEntry<K, V> getEntry(K k) {
        return this.map.get(k);
    }

    public DataStoreEntry<K, V> getOrCreateEntry(K k) {
        DataStoreEntry<K, V> entry = this.map.get(k);
        if (entry == null) {
            entry = new DataStoreEntry();
            entry.setKey(k);
            DataStoreEntry<K, V> tEntry = this.map.putIfAbsent(k, entry);
            if (tEntry != null) {
                entry = tEntry;
            }
        }
        return entry;
    }

    public V getV(K k) throws DataStoreException {
        DataStoreEntry<K, V> dse = this.map.get(k);
        return dse == null ? null : (V)this.ctx.getDataStoreEntryHelper().getV(dse);
    }

    public void remove(K k) {
        DataStoreEntry<K, V> entry = this.getOrCreateEntry(k);
        System.out.println("** ReplicaStore::remove(" + k);
    }

    public int size() {
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeExpired(long idleforMillis) {
        int result = 0;
        long now = System.currentTimeMillis();
        DataStoreEntryHelper<K, V> entryHelper = this.ctx.getDataStoreEntryHelper();
        Iterator<DataStoreEntry<K, V>> iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            DataStoreEntry<K, V> entry;
            DataStoreEntry<K, V> dataStoreEntry = entry = iterator.next();
            synchronized (dataStoreEntry) {
                if (entry.getLastAccessedAt() + idleforMillis < now) {
                    this.map.remove(entry.getKey());
                    ++result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpired(StoreEntryProcessor processor) throws DataStoreException {
        long now = System.currentTimeMillis();
        DataStoreEntryHelper<K, V> entryHelper = this.ctx.getDataStoreEntryHelper();
        Iterator<DataStoreEntry<K, V>> iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            DataStoreEntry<K, V> entry;
            DataStoreEntry<K, V> dataStoreEntry = entry = iterator.next();
            synchronized (dataStoreEntry) {
                if (((Boolean)processor.process(entry.getKey(), (Serializable)entryHelper.getV(entry))).booleanValue()) {
                    this.map.remove(entry.getKey());
                }
            }
        }
    }

    public Collection<K> keys() {
        return this.map.keySet();
    }

    public Collection<DataStoreEntry<K, V>> values() {
        return this.map.values();
    }
}

