/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.mapper;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.HashableKey;
import org.shoal.ha.group.GroupMemberEventListener;
import org.shoal.ha.mapper.KeyMapper;

public class DefaultKeyMapper
implements KeyMapper,
GroupMemberEventListener {
    Logger _logger = Logger.getLogger("org.shoal.ha.cache.mapper");
    private static final String[] _EMPTY_TARGETS = new String[]{null, null};
    private String myName;
    private String groupName;
    private ReentrantReadWriteLock.ReadLock rLock;
    private ReentrantReadWriteLock.WriteLock wLock;
    private volatile String[] members = new String[0];
    private volatile String[] previuousAliveAndReadyMembers = new String[0];

    public DefaultKeyMapper(String myName, String groupName) {
        this.myName = myName;
        this.groupName = groupName;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.rLock = rwLock.readLock();
        this.wLock = rwLock.writeLock();
        this.previuousAliveAndReadyMembers = new String[]{myName};
        this._logger.log(Level.INFO, "DefaultKeyMapper created for: myName: " + myName + "; groupName: " + groupName);
    }

    protected ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.rLock;
    }

    protected ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.wLock;
    }

    protected String[] getMembers() {
        return this.members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMappedInstance(String groupName, Object key1) {
        int hc = key1.hashCode();
        if (key1 instanceof HashableKey) {
            HashableKey k = (HashableKey)key1;
            hc = k.getHashKey() == null ? hc : k.getHashKey().hashCode();
        }
        hc = Math.abs(hc);
        try {
            this.rLock.lock();
            String string = this.members.length == 0 ? null : this.members[hc % this.members.length];
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findReplicaInstance(String groupName, Object key1, String keyMappingInfo) {
        if (keyMappingInfo != null) {
            return keyMappingInfo.split(":");
        }
        int hc = key1.hashCode();
        if (key1 instanceof HashableKey) {
            HashableKey k = (HashableKey)key1;
            hc = k.getHashKey() == null ? hc : k.getHashKey().hashCode();
        }
        hc = Math.abs(hc);
        try {
            String[] stringArray;
            this.rLock.lock();
            if (this.previuousAliveAndReadyMembers.length == 0) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.previuousAliveAndReadyMembers[hc % this.previuousAliveAndReadyMembers.length];
            }
            String[] stringArray3 = stringArray;
            return stringArray3;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onViewChange(String memberName, Collection<String> readOnlyCurrentAliveAndReadyMembers, Collection<String> readOnlyPreviousAliveAndReadyMembers, boolean isJoinEvent) {
        try {
            this.wLock.lock();
            TreeSet<String> currentMemberSet = new TreeSet<String>();
            currentMemberSet.addAll(readOnlyCurrentAliveAndReadyMembers);
            currentMemberSet.remove(this.myName);
            this.members = currentMemberSet.toArray(new String[0]);
            TreeSet<String> previousView = new TreeSet<String>();
            previousView.addAll(readOnlyPreviousAliveAndReadyMembers);
            if (!isJoinEvent) {
                previousView.remove(memberName);
            }
            this.previuousAliveAndReadyMembers = previousView.toArray(new String[0]);
            this.printMemberStates("onViewChange (isJoin: " + isJoinEvent + ")");
        }
        finally {
            this.wLock.unlock();
        }
    }

    private static int getDigestHashCode(String val) {
        int hc = val.hashCode();
        try {
            String hcStr = "_" + val.hashCode() + "_";
            MessageDigest dig = MessageDigest.getInstance("MD5");
            dig.update(hcStr.getBytes());
            dig.update(val.getBytes());
            dig.update(hcStr.getBytes());
            BigInteger bi = new BigInteger(dig.digest());
            hc = bi.intValue();
            return hc;
        }
        catch (NoSuchAlgorithmException nsaEx) {
            hc = val.hashCode();
            return hc;
        }
    }

    public void printMemberStates(String message) {
        StringBuilder sb = new StringBuilder("DefaultKeyMapper[" + this.myName + "]." + message + " currentView: ");
        String delim = "";
        for (String st : this.members) {
            sb.append(delim).append(st);
            delim = " : ";
        }
        sb.append("; previousView ");
        delim = "";
        for (String st : this.previuousAliveAndReadyMembers) {
            sb.append(delim).append(st);
            delim = " : ";
        }
        this._logger.log(Level.INFO, sb.toString());
    }
}

