/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.gjc.monitoring.JdbcRAConstants;
import com.sun.gjc.monitoring.SQLTraceProbeProvider;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.jdbc.SQLTraceListener;
import org.glassfish.api.jdbc.SQLTraceRecord;

public class SQLTraceDelegator
implements SQLTraceListener {
    protected List<SQLTraceListener> sqlTraceListenersList;
    private String poolName;
    private SQLTraceProbeProvider probeProvider = null;

    public SQLTraceProbeProvider getProbeProvider() {
        return this.probeProvider;
    }

    public SQLTraceDelegator() {
    }

    public SQLTraceDelegator(String poolName) {
        this.poolName = poolName;
        this.probeProvider = new SQLTraceProbeProvider();
    }

    public void registerSQLTraceListener(SQLTraceListener listener) {
        if (this.sqlTraceListenersList == null) {
            this.sqlTraceListenersList = new ArrayList<SQLTraceListener>();
        }
        this.sqlTraceListenersList.add(listener);
    }

    public void sqlTrace(SQLTraceRecord record) {
        if (this.sqlTraceListenersList != null) {
            for (SQLTraceListener listener : this.sqlTraceListenersList) {
                listener.sqlTrace(record);
            }
        }
        if (record != null) {
            Object[] params;
            record.setPoolName(this.poolName);
            String methodName = record.getMethodName();
            if (this.isMethodValidForCaching(methodName) && (params = record.getParams()) != null && params.length > 0) {
                Object param;
                String sqlQuery = null;
                int i$ = 0;
                Object[] arr$ = params;
                int len$ = arr$.length;
                if (i$ < len$ && (param = arr$[i$]) instanceof String) {
                    sqlQuery = param.toString();
                }
                if (sqlQuery != null) {
                    this.probeProvider.cacheSqlQueryEvent(this.poolName, sqlQuery);
                }
            }
        }
    }

    private boolean isMethodValidForCaching(String methodName) {
        return JdbcRAConstants.validSqlTracingMethodNames.contains(methodName);
    }
}

