/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.glassfish.loadbalancer.admin.cli.LBCommandsBase;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="disable-http-lb-server")
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@Cluster(value={RuntimeType.DAS})
public final class DisableHTTPLBServerCommand
extends LBCommandsBase
implements AdminCommand {
    @Param(primary=true)
    String target;
    @Param(optional=true, defaultValue="30")
    String timeout;
    @Inject
    Target tgt;
    @Inject
    LbConfigs lbconfigs;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableHTTPLBServerCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        int t = Integer.parseInt(this.timeout);
        if (t < 0) {
            String msg = localStrings.getLocalString("InvalidTimeout", "Invalid timeout {0}", new Object[]{this.timeout});
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (this.tgt.isCluster(this.target)) {
            this.updateLBForCluster(report, this.target, "false", this.timeout);
        } else {
            boolean foundTarget = false;
            List lbConfigs = this.lbconfigs.getLbConfig();
            for (LbConfig lc : lbConfigs) {
                ServerRef sRef = (ServerRef)lc.getRefByRef(ServerRef.class, this.target);
                if (sRef == null) {
                    logger.warning(localStrings.getLocalString("InvalidInstance", "Server {0} does not exist in {1}", new Object[]{this.target, lc.getName()}));
                    continue;
                }
                int curTout = Integer.parseInt(sRef.getDisableTimeoutInMinutes());
                boolean enabled = sRef.getLbEnabled().equals("true");
                if (!enabled && curTout == t) {
                    String msg = localStrings.getLocalString("ServerDisabled", "Server [{0}] is already disabled.", new Object[]{sRef.getRef()});
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                try {
                    this.updateLbEnabled(sRef, "false", null);
                }
                catch (TransactionFailure ex) {
                    String msg = localStrings.getLocalString("FailedToUpdateAttr", "Failed to update lb-enabled attribute for {0}", new Object[]{this.target});
                    report.setMessage(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setFailureCause((Throwable)ex);
                    return;
                }
                foundTarget = true;
            }
            if (!foundTarget) {
                ServerRef sRef = this.getServerRefFromCluster(report, this.target);
                if (sRef == null) {
                    String msg = localStrings.getLocalString("InvalidServer", "Server {0} does not exist", new Object[]{this.target});
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                int curTout = Integer.parseInt(sRef.getDisableTimeoutInMinutes());
                boolean enabled = sRef.getLbEnabled().equals("true");
                if (!enabled && curTout == t) {
                    String msg = localStrings.getLocalString("ServerDisabled", "Server [{0}] is already disabled.", new Object[]{sRef.getRef()});
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                try {
                    this.updateLbEnabled(sRef, "false", null);
                }
                catch (TransactionFailure ex) {
                    String msg = localStrings.getLocalString("FailedToUpdateAttr", "Failed to update lb-enabled attribute for {0}", new Object[]{this.target});
                    report.setMessage(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setFailureCause((Throwable)ex);
                    return;
                }
            }
        }
    }
}

