/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.catalina.Container;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.core.StandardContext;
import org.glassfish.web.ha.authenticator.HASessionData;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;

public class HASingleSignOnEntry
extends SingleSignOnEntry {
    protected long maxIdleTime;
    protected long version;
    protected JavaEEIOUtils ioUtils;

    public HASingleSignOnEntry() {
        this(null, null, null, null, null, null, 0L, 0L, 0L, null);
    }

    public HASingleSignOnEntry(Container container, HASingleSignOnEntryMetadata m, JavaEEIOUtils ioUtils) {
        this(m.getId(), null, m.getAuthType(), m.getUsername(), m.getPassword(), m.getRealmName(), m.getLastAccessTime(), m.getMaxIdleTime(), m.getVersion(), ioUtils);
        ByteArrayInputStream bais = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(m.getPrincipalBytes());
            bis = new BufferedInputStream(bais);
            ois = ioUtils.createObjectInputStream((InputStream)bis, true, ((Object)((Object)this)).getClass().getClassLoader());
            this.principal = (Principal)ois.readObject();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException ex) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ex) {}
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex) {}
            }
        }
        HashSet<Session> sessionSet = new HashSet<Session>();
        for (HASessionData data : m.getHASessionDataList()) {
            StandardContext context = (StandardContext)container.findChild(data.getContextPath());
            Session session = null;
            try {
                session = context.getManager().findSession(data.getSessionId());
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            sessionSet.add(session);
        }
        this.sessions = sessionSet.toArray(new Session[sessionSet.size()]);
    }

    public HASingleSignOnEntry(String id, Principal principal, String authType, String username, char[] password, String realmName, long lastAccessTime, long maxIdleTime, long version, JavaEEIOUtils ioUtils) {
        super(id, principal, authType, username, password, realmName);
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = maxIdleTime;
        this.version = version;
        this.ioUtils = ioUtils;
    }

    public HASingleSignOnEntryMetadata getMetadata() {
        ArrayList<HASessionData> sessionDataList = new ArrayList<HASessionData>();
        for (Session session : this.sessions) {
            sessionDataList.add(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
        }
        ByteArrayOutputStream baos = null;
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            bos = new BufferedOutputStream(bos);
            oos = this.ioUtils.createObjectOutputStream((OutputStream)baos, true);
            oos.writeObject(this.principal);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception ex) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception ex) {}
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception ex) {}
            }
        }
        return new HASingleSignOnEntryMetadata(this.id, baos.toByteArray(), this.authType, this.username, this.password, this.realmName, sessionDataList, this.lastAccessTime, this.maxIdleTime, this.version);
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public long getVersion() {
        return this.version;
    }
}

