/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.authentication;

import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBContext;
import javax.security.auth.Subject;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.ejb.api.EJBInvocation;
import org.glassfish.resource.common.PoolInfo;

public class BasicPasswordAuthenticationService
implements AuthenticationService {
    private String rarName_;
    private PoolInfo poolInfo_;
    ConnectorRegistry connectorRegistry_ = ConnectorRegistry.getInstance();
    static Logger _logger = LogDomains.getLogger(BasicPasswordAuthenticationService.class, (String)"javax.enterprise.resource.resourceadapter");
    private Object containerContext = null;
    private SecurityRoleMapperFactory securityRoleMapperFactory;

    public BasicPasswordAuthenticationService(String rarName, PoolInfo poolInfo) {
        this.rarName_ = rarName;
        this.poolInfo_ = poolInfo;
        _logger.log(Level.FINE, "Contructor:BasicPasswordAuthenticationService");
    }

    public Principal mapPrincipal(Principal callerPrincipal, Set principalSet) {
        RuntimeSecurityMap runtimeSecurityMap = this.connectorRegistry_.getRuntimeSecurityMap(this.poolInfo_);
        if (runtimeSecurityMap == null) {
            return null;
        }
        String principalName = callerPrincipal.getName();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Principal p : principalSet) {
            if (((Object)p).equals(callerPrincipal)) continue;
            String groupName = p.getName();
            groupNames.add(groupName);
        }
        if (this.isContainerContextAWebModuleObject()) {
            String roleName = this.getRoleName(callerPrincipal);
            return this.doMap(principalName, groupNames, roleName, runtimeSecurityMap);
        }
        return this.doMap(principalName, groupNames, null, runtimeSecurityMap);
    }

    private Principal doMap(String principalName, List groupNames, String roleName, RuntimeSecurityMap runtimeSecurityMap) {
        HashMap userNameSecurityMap = runtimeSecurityMap.getUserMap();
        HashMap groupNameSecurityMap = runtimeSecurityMap.getGroupMap();
        if (userNameSecurityMap.containsKey(principalName)) {
            return (Principal)userNameSecurityMap.get(principalName);
        }
        if (this.isContainerContextAWebModuleObject() && roleName != null && groupNameSecurityMap.containsKey(roleName)) {
            return (Principal)groupNameSecurityMap.get(roleName);
        }
        if (this.isContainerContextAEJBContainerObject() && roleName == null) {
            ComponentInvocation componentInvocation = ConnectorRuntime.getRuntime().getInvocationManager().getCurrentInvocation();
            EJBInvocation ejbInvocation = (EJBInvocation)componentInvocation;
            EJBContext ejbcontext = ejbInvocation.getEJBContext();
            Set s = groupNameSecurityMap.keySet();
            for (String entry : s) {
                boolean isInRole = false;
                try {
                    isInRole = ejbcontext.isCallerInRole(entry);
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "asciPasswordAuthentication::caller not in role " + entry);
                }
                if (!isInRole) continue;
                return (Principal)groupNameSecurityMap.get(entry);
            }
        }
        for (int j = 0; j < groupNames.size(); ++j) {
            String groupName = (String)groupNames.get(j);
            if (!groupNameSecurityMap.containsKey(groupName)) continue;
            return (Principal)groupNameSecurityMap.get(groupName);
        }
        if (userNameSecurityMap.containsKey("*")) {
            return (Principal)userNameSecurityMap.get("*");
        }
        if (groupNameSecurityMap.containsKey("*")) {
            return (Principal)groupNameSecurityMap.get("*");
        }
        return null;
    }

    private String getRoleName(Principal callerPrincipal) {
        String roleName2 = null;
        WebBundleDescriptor wbd = (WebBundleDescriptor)this.getComponentEnvManager().getCurrentJndiNameEnvironment();
        SecurityRoleMapperFactory securityRoleMapperFactory = this.getSecurityRoleMapperFactory();
        SecurityRoleMapper securityRoleMapper = securityRoleMapperFactory.getRoleMapper(wbd.getModuleID());
        Map map = securityRoleMapper.getRoleToSubjectMapping();
        Set roleSet = map.keySet();
        for (String roleName2 : roleSet) {
            Subject subject = (Subject)map.get(roleName2);
            Set<Principal> principalSet = subject.getPrincipals();
            if (!principalSet.contains(callerPrincipal)) continue;
            return roleName2;
        }
        return "";
    }

    private ComponentEnvManager getComponentEnvManager() {
        return ConnectorRuntime.getRuntime().getComponentEnvManager();
    }

    private ComponentInvocation getCurrentComponentInvocation() {
        return ConnectorRuntime.getRuntime().getInvocationManager().getCurrentInvocation();
    }

    private ComponentInvocation.ComponentInvocationType getCurrentComponentType() {
        return this.getCurrentComponentInvocation().getInvocationType();
    }

    private boolean isContainerContextAWebModuleObject() {
        return ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION.equals((Object)this.getCurrentComponentType());
    }

    private boolean isContainerContextAEJBContainerObject() {
        return ComponentInvocation.ComponentInvocationType.EJB_INVOCATION.equals((Object)this.getCurrentComponentType());
    }

    public SecurityRoleMapperFactory getSecurityRoleMapperFactory() {
        return ConnectorRuntime.getRuntime().getSecurityRoleMapperFactory();
    }
}

