/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.listener.PoolLifeCycleListener;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolAppEmitterImpl;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolAppProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolAppProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolAppStatsProvider;
import com.sun.enterprise.resource.pool.monitor.JdbcConnPoolAppProbeProvider;
import com.sun.enterprise.resource.pool.monitor.JdbcConnPoolAppStatsProvider;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.resource.common.PoolInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPoolEmitterImpl
implements PoolLifeCycleListener {
    private String poolName;
    private PoolInfo poolInfo;
    private ConnectionPoolProbeProvider poolProbeProvider;
    private Map<PoolInfo, Map<String, ConnectionPoolAppEmitterImpl>> appStatsMap = null;
    private Map<Long, String> resourceAppAssociationMap;
    private static Logger _logger = LogDomains.getLogger(ConnectionPoolEmitterImpl.class, (String)"javax.enterprise.resource.resourceadapter");
    private List<JdbcConnPoolAppStatsProvider> jdbcPoolAppStatsProviders = null;
    private List<ConnectorConnPoolAppStatsProvider> ccPoolAppStatsProviders = null;
    private ConnectorRuntime runtime;

    public ConnectionPoolEmitterImpl(PoolInfo poolInfo, ConnectionPoolProbeProvider provider) {
        this.poolInfo = poolInfo;
        this.poolName = poolInfo.getName();
        this.poolProbeProvider = provider;
        this.jdbcPoolAppStatsProviders = new ArrayList<JdbcConnPoolAppStatsProvider>();
        this.ccPoolAppStatsProviders = new ArrayList<ConnectorConnPoolAppStatsProvider>();
        this.appStatsMap = new HashMap<PoolInfo, Map<String, ConnectionPoolAppEmitterImpl>>();
        this.resourceAppAssociationMap = new HashMap<Long, String>();
        this.runtime = ConnectorRuntime.getRuntime();
    }

    @Override
    public void toString(StringBuffer stackTrace) {
        stackTrace.append("\n Monitoring Statistics for \n" + this.poolName);
        this.poolProbeProvider.toString(this.poolName, stackTrace);
    }

    @Override
    public void connectionAcquired(long resourceHandleId) {
        ConnectionPoolAppEmitterImpl appEmitter = this.detectAppBasedProviders(this.getAppName(resourceHandleId));
        this.poolProbeProvider.connectionAcquiredEvent(this.poolName);
        if (appEmitter != null) {
            appEmitter.connectionAcquired();
        }
    }

    @Override
    public void connectionRequestServed(long timeTakenInMillis) {
        this.poolProbeProvider.connectionRequestServedEvent(this.poolName, timeTakenInMillis);
    }

    @Override
    public void connectionTimedOut() {
        this.poolProbeProvider.connectionTimedOutEvent(this.poolName);
    }

    @Override
    public void connectionNotMatched() {
        this.poolProbeProvider.connectionNotMatchedEvent(this.poolName);
    }

    @Override
    public void connectionMatched() {
        this.poolProbeProvider.connectionMatchedEvent(this.poolName);
    }

    @Override
    public void connectionDestroyed(long resourceHandleId) {
        this.poolProbeProvider.connectionDestroyedEvent(this.poolName);
        this.resourceAppAssociationMap.remove(resourceHandleId);
    }

    @Override
    public void connectionReleased(long resourceHandleId) {
        ConnectionPoolAppEmitterImpl appEmitter = this.detectAppBasedProviders(this.getAppName(resourceHandleId));
        this.poolProbeProvider.connectionReleasedEvent(this.poolName);
        if (appEmitter != null) {
            appEmitter.connectionReleased();
        }
    }

    @Override
    public void connectionCreated() {
        this.poolProbeProvider.connectionCreatedEvent(this.poolName);
    }

    @Override
    public void foundPotentialConnectionLeak() {
        this.poolProbeProvider.potentialConnLeakEvent(this.poolName);
    }

    @Override
    public void connectionValidationFailed(int count) {
        this.poolProbeProvider.connectionValidationFailedEvent(this.poolName, count);
    }

    @Override
    public void connectionUsed(long resourceHandleId) {
        ConnectionPoolAppEmitterImpl appEmitter = this.detectAppBasedProviders(this.getAppName(resourceHandleId));
        this.poolProbeProvider.connectionUsedEvent(this.poolName);
        if (appEmitter != null) {
            appEmitter.connectionUsed();
        }
    }

    @Override
    public void connectionsFreed(int count) {
        this.poolProbeProvider.connectionsFreedEvent(this.poolName, count);
    }

    @Override
    public void decrementConnectionUsed(long resourceHandleId) {
        ConnectionPoolAppEmitterImpl appEmitter = this.detectAppBasedProviders(this.getAppName(resourceHandleId));
        this.poolProbeProvider.decrementConnectionUsedEvent(this.poolName);
        if (appEmitter != null) {
            appEmitter.decrementConnectionUsed();
        }
    }

    @Override
    public void decrementNumConnFree() {
        this.poolProbeProvider.decrementNumConnFreeEvent(this.poolName);
    }

    @Override
    public void incrementNumConnFree(boolean beingDestroyed, int steadyPoolSize) {
        this.poolProbeProvider.incrementNumConnFreeEvent(this.poolName, beingDestroyed, steadyPoolSize);
    }

    @Override
    public void connectionRequestQueued() {
        this.poolProbeProvider.connectionRequestQueuedEvent(this.poolName);
    }

    @Override
    public void connectionRequestDequeued() {
        this.poolProbeProvider.connectionRequestDequeuedEvent(this.poolName);
    }

    private String getAppName(long resourceHandleId) {
        InitialContext ic = null;
        String appName = null;
        try {
            ic = new InitialContext();
            appName = (String)ic.lookup("java:app/AppName");
        }
        catch (NamingException ex) {
            _logger.log(Level.FINE, "Unable to get application name using java:app/AppName method");
            appName = this.resourceAppAssociationMap.remove(resourceHandleId);
        }
        this.resourceAppAssociationMap.put(resourceHandleId, appName);
        return appName;
    }

    private ConnectionPoolAppEmitterImpl detectAppBasedProviders(String appName) {
        ConnectionPoolAppProbeProvider probeAppProvider = null;
        ConnectionPoolAppEmitterImpl connPoolAppEmitter = null;
        if (appName == null) {
            return null;
        }
        if (this.appStatsMap.containsKey(this.poolInfo)) {
            Map<String, ConnectionPoolAppEmitterImpl> appEmitters = this.appStatsMap.get(this.poolInfo);
            ConnectionPoolAppEmitterImpl emitter = appEmitters.get(appName);
            if (emitter != null) {
                return emitter;
            }
            if (!ConnectorsUtil.isApplicationScopedResource((PoolInfo)this.poolInfo)) {
                probeAppProvider = this.registerConnectionPool(appName);
                connPoolAppEmitter = this.addToList(appName, probeAppProvider, appEmitters);
            }
        } else if (!ConnectorsUtil.isApplicationScopedResource((PoolInfo)this.poolInfo)) {
            probeAppProvider = this.registerConnectionPool(appName);
            HashMap<String, ConnectionPoolAppEmitterImpl> appEmitters = new HashMap<String, ConnectionPoolAppEmitterImpl>();
            connPoolAppEmitter = this.addToList(appName, probeAppProvider, appEmitters);
        }
        return connPoolAppEmitter;
    }

    private ConnectionPoolAppProbeProvider registerConnectionPool(String appName) {
        ConnectionPoolAppProbeProvider probeAppProvider = null;
        ResourcePool pool = this.runtime.getConnectionPoolConfig(this.poolInfo);
        if (pool instanceof JdbcConnectionPool) {
            probeAppProvider = new JdbcConnPoolAppProbeProvider();
            JdbcConnPoolAppStatsProvider jdbcPoolAppStatsProvider = new JdbcConnPoolAppStatsProvider(this.poolInfo, appName);
            StatsProviderManager.register((String)"jdbc-connection-pool", (PluginPoint)PluginPoint.SERVER, (String)("resources/" + this.poolName + "/" + appName), (Object)jdbcPoolAppStatsProvider);
            this.jdbcPoolAppStatsProviders.add(jdbcPoolAppStatsProvider);
        } else if (pool instanceof ConnectorConnectionPool) {
            probeAppProvider = new ConnectorConnPoolAppProbeProvider();
            ConnectorConnPoolAppStatsProvider ccPoolAppStatsProvider = new ConnectorConnPoolAppStatsProvider(this.poolInfo, appName);
            StatsProviderManager.register((String)"connector-connection-pool", (PluginPoint)PluginPoint.SERVER, (String)("resources/" + this.poolName + "/" + appName), (Object)ccPoolAppStatsProvider);
            this.ccPoolAppStatsProviders.add(ccPoolAppStatsProvider);
        }
        return probeAppProvider;
    }

    private ConnectionPoolAppEmitterImpl addToList(String appName, ConnectionPoolAppProbeProvider probeAppProvider, Map<String, ConnectionPoolAppEmitterImpl> appEmitters) {
        ConnectionPoolAppEmitterImpl connPoolAppEmitter = null;
        if (probeAppProvider != null) {
            connPoolAppEmitter = new ConnectionPoolAppEmitterImpl(this.poolName, appName, probeAppProvider);
            appEmitters.put(appName, connPoolAppEmitter);
            this.appStatsMap.put(this.poolInfo, appEmitters);
        }
        this.runtime.getProbeProviderUtil().getConnPoolBootstrap().addToPoolEmitters(this.poolInfo, this);
        return connPoolAppEmitter;
    }

    public void unregisterAppStatsProviders() {
        for (JdbcConnPoolAppStatsProvider jdbcPoolAppStatsProvider : this.jdbcPoolAppStatsProviders) {
            StatsProviderManager.unregister((Object)jdbcPoolAppStatsProvider);
        }
        for (ConnectorConnPoolAppStatsProvider ccPoolAppStatsProvider : this.ccPoolAppStatsProviders) {
            StatsProviderManager.unregister((Object)ccPoolAppStatsProvider);
        }
        this.jdbcPoolAppStatsProviders.clear();
        this.ccPoolAppStatsProviders.clear();
    }
}

