/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.deployment.common.VersioningDeploymentException;
import org.glassfish.deployment.common.VersioningDeploymentSyntaxException;
import org.glassfish.deployment.common.VersioningWildcardException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningDeploymentUtil {
    public static final LocalStringManagerImpl LOCALSTRINGS = new LocalStringManagerImpl(VersioningDeploymentUtil.class);
    public static final String EXPRESSION_SEPARATOR = ":";
    public static final String EXPRESSION_WILDCARD = "*";
    public static final String REPOSITORY_DASH = "~";

    public static final String getUntaggedName(String appName) throws VersioningDeploymentSyntaxException {
        int colonIndex;
        if (appName != null && !appName.isEmpty() && (colonIndex = appName.indexOf(EXPRESSION_SEPARATOR)) != -1) {
            if (colonIndex == appName.length() - 1) {
                throw new VersioningDeploymentSyntaxException(LOCALSTRINGS.getLocalString("versioning.deployment.invalid.appname", "excepted version identifier after colon: {0}", new Object[]{appName}));
            }
            return appName.substring(0, colonIndex);
        }
        return appName;
    }

    public static final String getExpression(String appName) throws VersioningDeploymentSyntaxException {
        int colonIndex = appName.indexOf(EXPRESSION_SEPARATOR);
        if (colonIndex != -1) {
            if (colonIndex == appName.length() - 1) {
                throw new VersioningDeploymentSyntaxException(LOCALSTRINGS.getLocalString("versioning.deployment.invalid.appname", "excepted version expression/identifier after colon: {0}", new Object[]{appName}));
            }
            return appName.substring(colonIndex + 1, appName.length());
        }
        return null;
    }

    public static final void checkIdentifier(String appName) throws VersioningDeploymentSyntaxException {
        String identifier = VersioningDeploymentUtil.getExpression(appName);
        if (identifier != null && identifier.contains(EXPRESSION_WILDCARD)) {
            throw new VersioningWildcardException(LOCALSTRINGS.getLocalString("versioning.deployment.wildcard.not.allowed", "Wildcard character(s) are not allowed in a version identifier."));
        }
    }

    public static final List<String> getVersions(String untaggedName, List<Application> allApplications) {
        ArrayList<String> allVersions = new ArrayList<String>();
        for (Application app : allApplications) {
            if (!app.getName().startsWith(untaggedName + EXPRESSION_SEPARATOR) && !app.getName().equals(untaggedName)) continue;
            allVersions.add(app.getName());
        }
        return allVersions;
    }

    public static final List<String> matchExpression(List<String> listVersion, String appName) throws VersioningDeploymentException {
        if (listVersion.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        String expressionVersion = VersioningDeploymentUtil.getExpression(appName);
        if (expressionVersion == null) {
            if (listVersion.contains(appName)) {
                return listVersion.subList(listVersion.indexOf(appName), listVersion.indexOf(appName) + 1);
            }
            throw new VersioningDeploymentException(LOCALSTRINGS.getLocalString("versioning.deployment.version.notreg", "version {0} not registered", new Object[]{appName}));
        }
        if (expressionVersion.indexOf(EXPRESSION_WILDCARD) == -1) {
            if (listVersion.contains(appName)) {
                return listVersion.subList(listVersion.indexOf(appName), listVersion.indexOf(appName) + 1);
            }
            throw new VersioningDeploymentException(LOCALSTRINGS.getLocalString("versioning.deployment.version.notreg", "Version {0} not registered", new Object[]{appName}));
        }
        StringTokenizer st = new StringTokenizer(expressionVersion, EXPRESSION_WILDCARD);
        String lastToken = null;
        ArrayList<String> matchedVersions = new ArrayList<String>(listVersion);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            for (String app : listVersion) {
                String identifier = VersioningDeploymentUtil.getExpression(app);
                int lastTokenIndex = -1;
                if (lastToken != null) {
                    lastTokenIndex = identifier.indexOf(lastToken);
                }
                if (identifier != null) {
                    if (expressionVersion.startsWith(token) && !identifier.startsWith(token)) {
                        matchedVersions.remove(app);
                        continue;
                    }
                    if (expressionVersion.endsWith(token) && !identifier.endsWith(token)) {
                        matchedVersions.remove(app);
                        continue;
                    }
                    if (identifier.contains(token.subSequence(0, token.length() - 1)) && identifier.indexOf(token) > lastTokenIndex) continue;
                    matchedVersions.remove(app);
                    continue;
                }
                matchedVersions.remove(app);
            }
            lastToken = token;
        }
        return matchedVersions;
    }

    public static final String getRepositoryName(String appName) throws VersioningDeploymentSyntaxException {
        String expression = VersioningDeploymentUtil.getExpression(appName);
        String untaggedName = VersioningDeploymentUtil.getUntaggedName(appName);
        if (expression != null) {
            StringBuilder repositoryNameBuilder = new StringBuilder(untaggedName);
            repositoryNameBuilder.append(REPOSITORY_DASH);
            repositoryNameBuilder.append(expression);
            return repositoryNameBuilder.toString();
        }
        return untaggedName;
    }

    public static final Boolean isUntagged(String appName) {
        Boolean isUntagged = false;
        try {
            String untaggedName = VersioningDeploymentUtil.getUntaggedName(appName);
            if (untaggedName != null && untaggedName.equals(appName)) {
                isUntagged = true;
            }
        }
        catch (VersioningDeploymentSyntaxException versioningDeploymentSyntaxException) {
            // empty catch block
        }
        return isUntagged;
    }
}

