/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeDisposerResolver;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.AnnotatedTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployerEnvironment {
    private final Map<WeldClass<?>, AbstractClassBean<?>> classBeanMap = new HashMap();
    private final Map<WeldMethodKey<?, ?>, ProducerMethod<?, ?>> producerMethodBeanMap = new HashMap();
    private final Set<RIBean<?>> beans;
    private final Set<ObserverMethodImpl<?, ?>> observers;
    private final List<DisposalMethod<?, ?>> allDisposalBeans = new ArrayList();
    private final Set<DisposalMethod<?, ?>> resolvedDisposalBeans = new HashSet();
    private final Set<DecoratorImpl<?>> decorators;
    private final Set<InterceptorImpl<?>> interceptors;
    private final EjbDescriptors ejbDescriptors;
    private final TypeSafeDisposerResolver disposalMethodResolver;
    private final ClassTransformer classTransformer;
    private final Set<WeldClass<?>> newManagedBeanClasses;
    private final Set<InternalEjbDescriptor<?>> newSessionBeanDescriptors;

    public BeanDeployerEnvironment(EjbDescriptors ejbDescriptors, BeanManagerImpl manager) {
        this.beans = new HashSet();
        this.decorators = new HashSet();
        this.interceptors = new HashSet();
        this.observers = new HashSet();
        this.ejbDescriptors = ejbDescriptors;
        this.disposalMethodResolver = new TypeSafeDisposerResolver(manager, this.allDisposalBeans);
        this.classTransformer = manager.getServices().get(ClassTransformer.class);
        this.newManagedBeanClasses = new HashSet();
        this.newSessionBeanDescriptors = new HashSet();
    }

    public Set<WeldClass<?>> getNewManagedBeanClasses() {
        return this.newManagedBeanClasses;
    }

    public Set<InternalEjbDescriptor<?>> getNewSessionBeanDescriptors() {
        return this.newSessionBeanDescriptors;
    }

    public <X, T> ProducerMethod<X, T> getProducerMethod(WeldMethod<X, T> method) {
        WeldMethodKey<T, X> key = new WeldMethodKey<T, X>(method);
        if (!this.producerMethodBeanMap.containsKey(key)) {
            return null;
        }
        ProducerMethod<?, ?> bean = this.producerMethodBeanMap.get(key);
        bean.initialize(this);
        return bean;
    }

    public AbstractClassBean<?> getClassBean(WeldClass<?> clazz) {
        if (!this.classBeanMap.containsKey(clazz)) {
            return null;
        }
        AbstractClassBean<?> bean = this.classBeanMap.get(clazz);
        bean.initialize(this);
        return bean;
    }

    public void addProducerMethod(ProducerMethod<?, ?> bean) {
        this.producerMethodBeanMap.put(new WeldMethodKey(bean.getWeldAnnotated()), bean);
        this.addAbstractBean(bean);
    }

    public void addProducerField(ProducerField<?, ?> bean) {
        this.addAbstractBean(bean);
    }

    public void addExtension(ExtensionBean bean) {
        this.beans.add(bean);
    }

    public void addBuiltInBean(AbstractBuiltInBean<?> bean) {
        this.beans.add(bean);
    }

    protected void addAbstractClassBean(AbstractClassBean<?> bean) {
        if (!(bean instanceof NewBean)) {
            this.classBeanMap.put((WeldClass<?>)bean.getWeldAnnotated(), bean);
        }
        this.addAbstractBean(bean);
    }

    public void addManagedBean(ManagedBean<?> bean) {
        this.newManagedBeanClasses.add((WeldClass<?>)bean.getWeldAnnotated());
        this.addAbstractClassBean(bean);
    }

    public void addSessionBean(SessionBean<?> bean) {
        this.newSessionBeanDescriptors.add(bean.getEjbDescriptor());
        this.addAbstractClassBean(bean);
    }

    public void addNewManagedBean(NewManagedBean<?> bean) {
        this.beans.add(bean);
    }

    public void addNewSessionBean(NewSessionBean<?> bean) {
        this.beans.add(bean);
    }

    protected void addAbstractBean(AbstractBean<?, ?> bean) {
        this.addNewBeansFromInjectionPoints(bean);
        this.beans.add(bean);
    }

    public void addDecorator(DecoratorImpl<?> bean) {
        this.decorators.add(bean);
    }

    public void addInterceptor(InterceptorImpl<?> bean) {
        this.interceptors.add(bean);
    }

    public void addDisposesMethod(DisposalMethod<?, ?> bean) {
        this.allDisposalBeans.add(bean);
        this.addNewBeansFromInjectionPoints(bean);
    }

    public void addObserverMethod(ObserverMethodImpl<?, ?> observer) {
        this.observers.add(observer);
        this.addNewBeansFromInjectionPoints(observer.getNewInjectionPoints());
    }

    private void addNewBeansFromInjectionPoints(AbstractBean<?, ?> bean) {
        this.addNewBeansFromInjectionPoints(bean.getNewInjectionPoints());
    }

    private void addNewBeansFromInjectionPoints(Set<WeldInjectionPoint<?, ?>> newInjectionPoints) {
        for (WeldInjectionPoint<?, ?> injectionPoint : newInjectionPoints) {
            if (injectionPoint.getJavaClass() == Instance.class || injectionPoint.getJavaClass() == Event.class) continue;
            New _new = injectionPoint.getAnnotation(New.class);
            if (_new.value().equals(New.class)) {
                this.addNewBeanFromInjecitonPoint(injectionPoint.getJavaClass(), injectionPoint.getBaseType());
                continue;
            }
            this.addNewBeanFromInjecitonPoint(_new.value(), _new.value());
        }
    }

    private void addNewBeanFromInjecitonPoint(Class<?> rawType, Type baseType) {
        if (this.getEjbDescriptors().contains(rawType)) {
            this.newSessionBeanDescriptors.add(this.getEjbDescriptors().getUnique(rawType));
        } else {
            this.newManagedBeanClasses.add(this.classTransformer.loadClass(rawType, baseType));
        }
    }

    public Set<? extends RIBean<?>> getBeans() {
        return Collections.unmodifiableSet(this.beans);
    }

    public Set<DecoratorImpl<?>> getDecorators() {
        return Collections.unmodifiableSet(this.decorators);
    }

    public Set<InterceptorImpl<?>> getInterceptors() {
        return Collections.unmodifiableSet(this.interceptors);
    }

    public Set<ObserverMethodImpl<?, ?>> getObservers() {
        return Collections.unmodifiableSet(this.observers);
    }

    public Set<DisposalMethod<?, ?>> getUnresolvedDisposalBeans() {
        HashSet beans = new HashSet(this.allDisposalBeans);
        beans.removeAll(this.resolvedDisposalBeans);
        return Collections.unmodifiableSet(beans);
    }

    public EjbDescriptors getEjbDescriptors() {
        return this.ejbDescriptors;
    }

    public <X> Set<DisposalMethod<X, ?>> resolveDisposalBeans(Set<Type> types, Set<Annotation> qualifiers, AbstractClassBean<X> declaringBean) {
        Set beans = this.disposalMethodResolver.resolve(new ResolvableBuilder().addTypes(types).addQualifiers(qualifiers).setDeclaringBean(declaringBean).create());
        this.resolvedDisposalBeans.addAll(beans);
        return Collections.unmodifiableSet(beans);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeldMethodKey<T, X> {
        final WeldMethod meth;

        WeldMethodKey(WeldMethod<T, X> meth) {
            this.meth = meth;
        }

        public boolean equals(Object other) {
            if (other instanceof WeldMethodKey) {
                WeldMethodKey o = (WeldMethodKey)other;
                return AnnotatedTypes.compareAnnotatedCallable(this.meth, o.meth);
            }
            return false;
        }

        public int hashCode() {
            return ((Method)this.meth.getJavaMember()).hashCode();
        }
    }
}

