/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventPublishingInhabitant<T>
extends AbstractInhabitantImpl<T> {
    protected volatile Inhabitant<T> real;
    private HashSet<InhabitantListener> listeners;

    EventPublishingInhabitant() {
        this.real = null;
    }

    EventPublishingInhabitant(Inhabitant<?> delegate) {
        this(delegate, null);
    }

    EventPublishingInhabitant(Inhabitant<?> delegate, InhabitantListener listener) {
        this.real = delegate;
        if (null != listener) {
            this.addInhabitantListener(listener);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.typeName() + ", active: " + this.real + ")";
    }

    @Override
    public String typeName() {
        return null == this.real ? null : this.real.typeName();
    }

    @Override
    public MultiMap<String, String> metadata() {
        return null == this.real ? null : this.real.metadata();
    }

    @Override
    public void release() {
        boolean wasActive = this.isInstantiated();
        if (null != this.real) {
            this.real.release();
        }
        if (wasActive && !this.isInstantiated()) {
            this.notify(InhabitantListener.EventType.INHABITANT_RELEASED);
        }
    }

    @Override
    public boolean isInstantiated() {
        return null != this.real && this.real.isInstantiated();
    }

    @Override
    public Class<T> type() {
        if (null == this.real) {
            throw new IllegalStateException();
        }
        boolean wasActive = this.real.isInstantiated();
        Class<T> t = this.real.type();
        if (!wasActive && this.real.isInstantiated()) {
            this.notify(InhabitantListener.EventType.INHABITANT_ACTIVATED);
        }
        return t;
    }

    @Override
    public T get(Inhabitant onBehalfOf) {
        if (null == this.real) {
            this.fetch();
        }
        boolean wasActive = this.real.isInstantiated();
        T result = this.real.get(onBehalfOf);
        if (!wasActive && this.real.isInstantiated()) {
            this.notify(InhabitantListener.EventType.INHABITANT_ACTIVATED);
        }
        return result;
    }

    protected void fetch() {
        throw new IllegalStateException();
    }

    public synchronized void addInhabitantListener(InhabitantListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException();
        }
        if (null == this.listeners) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    public boolean removeInhabitantListener(InhabitantListener listener) {
        return null == this.listeners ? false : this.listeners.remove(listener);
    }

    protected synchronized void notify(InhabitantListener.EventType eventType) {
        if (null != this.listeners) {
            Iterator<InhabitantListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                InhabitantListener listener = iter.next();
                try {
                    boolean keepListening = listener.inhabitantChanged(eventType, this);
                    if (keepListening) continue;
                    iter.remove();
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "exception caught from listener:", e);
                }
            }
        }
    }
}

