/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.flashlight.datatree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/html"})
public class TreeNodeHtmlProvider
extends BaseProvider<List<TreeNode>> {
    public TreeNodeHtmlProvider() {
        super(List.class, MediaType.TEXT_HTML_TYPE);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if ("java.util.List<org.glassfish.flashlight.datatree.TreeNode>".equals(genericType.toString())) {
            return mediaType.isCompatible(this.supportedMediaType);
        }
        return false;
    }

    @Override
    public String getContent(List<TreeNode> proxy) {
        String result = ProviderUtil.getHtmlHeader();
        result = result + "<h1>" + Util.upperCaseFirstLetter(Util.decode(Util.getName(this.uriInfo.getPath(), '/'))) + "</h1>" + "<hr>";
        if (proxy.isEmpty() && this.uriInfo.getPath().equalsIgnoreCase("domain")) {
            result = result + ProviderUtil.getHint(this.uriInfo, "text/html");
        }
        String attributes = this.getAttributes(proxy);
        result = ProviderUtil.getHtmlForComponent(attributes, "Attributes", result);
        String childResourceLinks = this.getResourcesLinks(proxy);
        result = ProviderUtil.getHtmlForComponent(childResourceLinks, "childResources", result);
        result = result + "</html></body>";
        return result;
    }

    private String getAttributes(List<TreeNode> nodeList) {
        String result = "";
        for (TreeNode node : nodeList) {
            if (node.hasChildNodes()) continue;
            result = result + this.htmlForNode(node.getName(), node.getValue());
        }
        return result;
    }

    private String getResourcesLinks(List<TreeNode> nodeList) {
        String result = "";
        for (TreeNode node : nodeList) {
            if (!node.hasChildNodes()) continue;
            try {
                String elementName = node.getName();
                elementName = elementName.replaceAll("\\\\.", "\\.");
                result = result + "<a href=\"" + ProviderUtil.getElementLink(this.uriInfo, elementName) + "\">";
                result = result + elementName;
                result = result + "</a>";
                result = result + "<br>";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private String htmlForNode(String name, Object value) {
        String result = "";
        if (value == null) {
            return result;
        }
        try {
            if (value instanceof Statistic) {
                Statistic statisticObject = (Statistic)value;
                if (!(result = result + this.getStatisticRepresentation(statisticObject)).equals("")) {
                    result = "<h3>" + name + "</h3>" + "<div><dl>" + result + "</dl></div>";
                }
                result = result + "<br class=\"separator\">";
                return result;
            }
            if (value instanceof Stats) {
                boolean firstEntry = true;
                String lineSpacing = "";
                for (Statistic statistic : ((Stats)value).getStatistics()) {
                    String statResult = this.getStatisticRepresentation(statistic);
                    if (!statResult.equals("")) {
                        if (!firstEntry) {
                            lineSpacing = "<br><br>";
                        }
                        statResult = "<dt>" + lineSpacing + "<b>" + statistic.getName() + "</b></dt><br>" + statResult + "<br>";
                        firstEntry = false;
                    }
                    result = result + statResult;
                    statResult = "";
                }
                if (!result.equals("")) {
                    result = "<h3>" + name + "</h3>" + "<div><dl>" + result + "</dl></div>";
                }
                result = result + "<br class=\"separator\">";
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = result + "<dt><label for=\"" + name + "\">" + name + ":&nbsp;" + "</label></dt>";
        result = result + "<dd>" + value.toString() + "</dd>";
        result = "<div><dl>" + result + "</dl></div>";
        return result;
    }

    private String getStatisticRepresentation(Statistic statistic) throws IllegalAccessException, InvocationTargetException {
        String result = "";
        Map<String, Object> map = ProviderUtil.getStatistic(statistic);
        Set<String> attributes = map.keySet();
        for (String attributeName : attributes) {
            Object attributeValue = map.get(attributeName);
            result = result + "<dt><label for=\"" + attributeName + "\">" + attributeName + ":&nbsp;" + "</label></dt>";
            result = result + "<dd>" + attributeValue.toString() + "</dd>";
        }
        return result;
    }
}

