/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.flashlight.datatree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml"})
public class TreeNodeXmlProvider
extends BaseProvider<List<TreeNode>> {
    public TreeNodeXmlProvider() {
        super(List.class, MediaType.APPLICATION_XML_TYPE);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if ("java.util.List<org.glassfish.flashlight.datatree.TreeNode>".equals(genericType.toString())) {
            return mediaType.isCompatible(this.supportedMediaType);
        }
        return false;
    }

    @Override
    public String getContent(List<TreeNode> proxy) {
        String attributes;
        String result = "<entity";
        if (proxy.isEmpty() && this.uriInfo.getPath().equalsIgnoreCase("domain")) {
            result = result + ProviderUtil.getHint(this.uriInfo, "application/xml");
        }
        if ((attributes = this.getAttributes(proxy)) != null && attributes.length() > 0) {
            result = result + attributes;
        }
        result = result + this.getResourcesLinks(proxy);
        result = result + ProviderUtil.getEndXmlElement("entity");
        return result;
    }

    private String getAttributes(List<TreeNode> nodeList) {
        String result = "";
        for (TreeNode node : nodeList) {
            String value;
            if (node.hasChildNodes() || (value = this.xmlForPrimitiveValue(node.getValue())).length() <= 0) continue;
            result = result + " " + node.getName() + "=" + ProviderUtil.quote(this.xmlForPrimitiveValue(node.getValue()));
        }
        result = result + ">" + "\n\n";
        for (TreeNode node : nodeList) {
            if (node.hasChildNodes()) continue;
            result = result + this.xmlForStatisticValue(node.getValue());
        }
        return result;
    }

    private String getResourcesLinks(List<TreeNode> nodeList) {
        String result = "";
        for (TreeNode node : nodeList) {
            if (!node.hasChildNodes()) continue;
            try {
                result = result + "  ";
                result = result + ProviderUtil.getStartXmlElement("childResource");
                String elementName = node.getName();
                result = result + ProviderUtil.getElementLink(this.uriInfo, elementName);
                result = result + ProviderUtil.getEndXmlElement("childResource");
                result = result + "\n";
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (result.length() > 1) {
            result = result + "\n";
        }
        return result;
    }

    private String xmlForPrimitiveValue(Object value) {
        String result = "";
        if (value != null && !(value instanceof Statistic) && !(value instanceof Stats)) {
            result = value.toString();
        }
        return result;
    }

    private String xmlForStatisticValue(Object value) {
        String result = "";
        if (value == null) {
            return result;
        }
        try {
            if (value instanceof Statistic) {
                Statistic statisticObject = (Statistic)value;
                result = result + this.getStatisticRepresentation(statisticObject);
            } else if (value instanceof Stats) {
                for (Statistic statistic : ((Stats)value).getStatistics()) {
                    String statResult = this.getStatisticRepresentation(statistic);
                    if (statResult.equals("")) continue;
                    result = result + statResult;
                    statResult = "";
                }
            }
            return result;
        }
        catch (Exception exception) {
            return result;
        }
    }

    private String getStatisticRepresentation(Statistic statistic) throws IllegalAccessException, InvocationTargetException {
        String result = "";
        Map<String, Object> map = ProviderUtil.getStatistic(statistic);
        Set<String> attributes = map.keySet();
        result = result + "  ";
        result = result + "<" + statistic.getName().replace('/', '_');
        for (String attributeName : attributes) {
            Object attributeValue = map.get(attributeName);
            result = " " + result + " " + attributeName + "=" + ProviderUtil.quote(attributeValue.toString());
        }
        result = result + ">";
        result = result + ProviderUtil.getEndXmlElement(statistic.getName().replace('/', '_'));
        result = result + "\n\n";
        return result;
    }
}

