/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.el.PageSessionResolver;
import com.sun.jsftemplating.handlers.NavigationHandlers;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.MiscUtil;
import org.glassfish.admingui.common.util.TargetUtil;
import org.glassfish.admingui.common.util.V3AMX;
import org.glassfish.admingui.common.util.V3AMXUtil;

public class CommonHandlers {
    private static final int INDEX = 0;

    public static void initClusterSessionAttribute(HandlerContext handlerCtx) {
        Map<String, Object> sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        sessionMap.put("appSummaryView", true);
        sessionMap.put("webSummaryView", true);
        sessionMap.put("ejbSummaryView", true);
        sessionMap.put("appclientSummaryView", true);
        sessionMap.put("rarSummaryView", true);
        sessionMap.put("lifecycleSummaryView", true);
        sessionMap.put("adminObjectSummaryView", true);
        sessionMap.put("connectorResSummaryView", true);
        sessionMap.put("customResSummaryView", true);
        sessionMap.put("externalResSummaryView", true);
        sessionMap.put("javaMailSessionSummaryView", true);
        sessionMap.put("jdbcResSummaryView", true);
        sessionMap.put("jmsConnectionSummaryView", true);
        sessionMap.put("jmsDestinationSummaryView", true);
    }

    public static void initSessionAttributes(HandlerContext handlerCtx) {
        Object initialized = FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("_SESSION_INITIALIZED");
        if (initialized == null) {
            GuiUtil.initSessionAttributes();
        }
    }

    public static void getFieldLengths(HandlerContext handlerCtx) {
        ResourceBundle bundle = (ResourceBundle)handlerCtx.getInputValue("bundle");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String key : bundle.keySet()) {
            try {
                result.put(key, Integer.decode(bundle.getString(key)));
            }
            catch (NumberFormatException ex) {
                GuiUtil.getLogger().warning("Field length is expected to be a number, but got ('" + bundle.getString(key) + "') instead for key '" + key + "'.");
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void initProductInfoAttributes(HandlerContext handlerCtx) {
        Map<String, Object> sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        Object initialized = sessionMap.get("_INFO_SESSION_INITIALIZED");
        if (initialized != null) {
            return;
        }
        sessionMap.put("productImageURL", GuiUtil.getMessage("productImage.URL"));
        sessionMap.put("productImageWidth", Integer.parseInt(GuiUtil.getMessage("productImage.width")));
        sessionMap.put("productImageHeight", Integer.parseInt(GuiUtil.getMessage("productImage.height")));
        sessionMap.put("loginProductImageURL", GuiUtil.getMessage("login.productImage.URL"));
        sessionMap.put("loginProductImageWidth", Integer.parseInt(GuiUtil.getMessage("login.productImage.width")));
        sessionMap.put("loginProductImageHeight", Integer.parseInt(GuiUtil.getMessage("login.productImage.height")));
        sessionMap.put("fullProductName", GuiUtil.getMessage("versionImage.description"));
        sessionMap.put("loginButtonTooltip", GuiUtil.getMessage("loginButtonTooltip"));
        sessionMap.put("mastHeadDescription", GuiUtil.getMessage("mastHeadDescription"));
        sessionMap.put("_INFO_SESSION_INITIALIZED", "TRUE");
    }

    public static void getListElement(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        Integer selectedIndex = (Integer)handlerCtx.getInputValue("index");
        String[] listItem = null;
        if (list != null) {
            if (selectedIndex == null) {
                selectedIndex = new Integer(0);
            }
            listItem = new String[]{(String)list.get(selectedIndex)};
        }
        handlerCtx.setOutputValue("selectedIndex", listItem);
    }

    public static void removeListElement(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        String name = (String)handlerCtx.getInputValue("name");
        Object listItem = null;
        if (list != null) {
            list.remove(name);
        }
        handlerCtx.setOutputValue("finalList", (Object)list);
    }

    public static void createAttributeMap(HandlerContext handlerCtx) {
        List keys = (List)handlerCtx.getInputValue("keys");
        List values = (List)handlerCtx.getInputValue("values");
        HashMap map = new HashMap();
        if (keys != null && values != null) {
            for (int i = 0; i < keys.size(); ++i) {
                map.put(keys.get(i), values.get(i));
            }
        }
        handlerCtx.setOutputValue("map", map);
    }

    public static void selectiveEncode(HandlerContext handlerCtx) {
        String value = (String)handlerCtx.getInputValue("value");
        String delim = (String)handlerCtx.getInputValue("delim");
        String encType = (String)handlerCtx.getInputValue("type");
        String encodedString = GuiUtil.encode(value, delim, encType);
        handlerCtx.setOutputValue("result", (Object)encodedString);
    }

    public static void logout(HandlerContext handlerCtx) {
        handlerCtx.getFacesContext().getExternalContext().invalidateSession();
    }

    public static void getRestartURL(HandlerContext handlerCtx) {
        String port = "" + V3AMXUtil.getAdminPort();
        String security = (String)V3AMX.getInstance().getAdminListener().findProtocol().attributesMap().get("SecurityEnabled");
        String url = security.equals("true") ? "https" : "http";
        url = url + "://" + GuiUtil.getSessionValue("serverName") + ":" + port;
        handlerCtx.setOutputValue("url", (Object)url);
    }

    public static void setComponentRequired(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("id");
        String required = (String)handlerCtx.getInputValue("required");
        UIViewRoot viewRoot = handlerCtx.getFacesContext().getViewRoot();
        if (viewRoot == null) {
            return;
        }
        try {
            UIInput targetComponent = (UIInput)((UIComponent)viewRoot).findComponent(id);
            if (targetComponent != null) {
                targetComponent.setRequired(Boolean.valueOf(required));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void testExists(HandlerContext handlerCtx) {
        String attr = (String)handlerCtx.getInputValue("attr");
        if (GuiUtil.isEmpty(attr)) {
            handlerCtx.setOutputValue("defined", (Object)false);
        } else {
            handlerCtx.setOutputValue("defined", (Object)true);
        }
    }

    public static void getRequestValue(HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("key");
        Object defaultValue = handlerCtx.getInputValue("default");
        Object value = handlerCtx.getFacesContext().getExternalContext().getRequestParameterMap().get(key);
        if (value == null || "".equals(value)) {
            value = handlerCtx.getFacesContext().getExternalContext().getRequestMap().get(key);
            if (value == null && defaultValue != null) {
                value = defaultValue;
            }
        } else {
            value = Util.htmlEscape((String)value);
        }
        handlerCtx.setOutputValue("value", value);
    }

    public void longAdd(HandlerContext handlerCtx) {
        Long result = new Long(0L);
        try {
            Long long1 = (Long)handlerCtx.getInputValue("Long1");
            Long long2 = (Long)handlerCtx.getInputValue("Long2");
            result = new Long(long1 + long2);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().warning("Exception in longAdd, return 0 ");
        }
        handlerCtx.setOutputValue("LongResult", (Object)result);
    }

    public void getCurrentTime(HandlerContext handlerCtx) {
        Date d = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, handlerCtx.getFacesContext().getViewRoot().getLocale());
        String currentTime = dateFormat.format(d);
        handlerCtx.setOutputValue("CurrentTime", (Object)currentTime);
    }

    public void checkRestart(HandlerContext handlerCtx) {
        List changes = V3AMX.getInstance().getDomainRoot().getExt().getSystemStatus().getRestartRequiredChanges();
        handlerCtx.setOutputValue("RestartRequired", (Object)(changes.size() > 0 ? 1 : 0));
        handlerCtx.setOutputValue("unprocessedChanges", (Object)changes);
    }

    public void handleError(HandlerContext handlerCtx) {
        String detail = (String)handlerCtx.getInputValue("detail");
        GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), detail);
        handlerCtx.getFacesContext().renderResponse();
    }

    public static void onlyDas(HandlerContext handlerCtx) {
        boolean onlyDAS = TargetUtil.getClusters().isEmpty() && TargetUtil.getStandaloneInstances().isEmpty();
        handlerCtx.setOutputValue("onlyDAS", (Object)onlyDAS);
    }

    public void testLoginBypass(HandlerContext handlerCtx) {
        String user = null;
        try {
            user = V3AMX.getInstance().getRealmsMgr().getAnonymousUser();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUtil.getLogger().severe("Cannot determine anonymous login.  Login enforced.");
            user = null;
        }
        handlerCtx.setOutputValue("byPass", (Object)(user == null ? Boolean.FALSE : Boolean.TRUE));
        handlerCtx.setOutputValue("loginUser", (Object)(user == null ? "" : user));
    }

    public static void setValueExpression(HandlerContext handlerCtx) {
        MiscUtil.setValueExpression((String)handlerCtx.getHandler().getInputValue("expression"), handlerCtx.getInputValue("value"));
    }

    public static void setPartialRequest(HandlerContext context) {
        boolean isPartial = (Boolean)context.getInputValue("value");
        context.getFacesContext().getPartialViewContext().setPartialRequest(isPartial);
    }

    public static void navigate(HandlerContext context) {
        context.getFacesContext().getPartialViewContext().setPartialRequest(false);
        NavigationHandlers.navigate((HandlerContext)context);
    }

    public static void redirect(HandlerContext context) {
        String page = (String)context.getInputValue("page");
        FacesContext ctx = context.getFacesContext();
        page = CommonHandlers.handleBareAttribute(ctx, page);
        try {
            ((HttpServletResponse)ctx.getExternalContext().getResponse()).sendRedirect(page);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to redirect to page '" + page + "'!", ex);
        }
        ctx.responseComplete();
    }

    private static String handleBareAttribute(FacesContext ctx, String url) {
        String request;
        UIViewRoot root = ctx.getViewRoot();
        Map pageSession = PageSessionResolver.getPageSession((FacesContext)ctx, (UIViewRoot)root);
        if (pageSession == null) {
            pageSession = PageSessionResolver.createPageSession((FacesContext)ctx, (UIViewRoot)root);
        }
        if ((request = ctx.getExternalContext().getRequestParameterMap().get("bare")) != null) {
            if (request.equalsIgnoreCase("true")) {
                url = CommonHandlers.addQueryStringParam(url, "bare", "true");
                request = "true";
            } else {
                request = "false";
            }
            pageSession.put("bare", request);
        } else {
            Object pageSessionValue = pageSession.get("bare");
            if (Boolean.TRUE.equals(pageSessionValue)) {
                url = CommonHandlers.addQueryStringParam(url, "bare", "true");
            } else {
                pageSession.put("bare", "false");
            }
        }
        return url;
    }

    private static String addQueryStringParam(String url, String name, String value) {
        String sep = "?";
        if (url.indexOf("?") > -1) {
            sep = "&";
        }
        String insert = sep + name + "=" + value;
        int hash = url.indexOf("#");
        url = hash > -1 ? url.substring(0, hash - 1) + insert + url.substring(hash) : url + insert;
        return url;
    }
}

