/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.tree;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.component.factory.tree.TreeAdaptor;
import com.sun.jsftemplating.component.factory.tree.TreeAdaptorBase;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.event.CommandActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admingui.common.tree.FilterTreeEvent;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanTreeAdaptor
extends TreeAdaptorBase {
    private String _methodName = null;
    String _objectName = null;
    private Object[] _paramsArray = null;
    private String[] _paramTypesArray = null;
    private String _nameAtt = null;
    private String _nameMethod = null;
    private String _amxChildType = null;
    List _children = null;

    private MBeanTreeAdaptor() {
    }

    protected MBeanTreeAdaptor(LayoutComponent desc, UIComponent parent) {
        super(desc, parent);
    }

    public static TreeAdaptor getInstance(FacesContext ctx, LayoutComponent desc, UIComponent parent) {
        return new MBeanTreeAdaptor(desc, parent);
    }

    public void init() {
        UIComponent parent;
        FacesContext ctx = FacesContext.getCurrentInstance();
        LayoutComponent desc = this.getLayoutComponent();
        Object val = desc.getEvaluatedOption(ctx, "objectName", parent = this.getParentUIComponent());
        if (val == null) {
            throw new IllegalArgumentException("'objectName' must be specified!");
        }
        this._objectName = (String)val;
        this._amxChildType = (String)desc.getEvaluatedOption(ctx, "amxChildType", parent);
        this._paramsArray = null;
        val = desc.getEvaluatedOption(ctx, "parameters", parent);
        if (val != null) {
            this._paramsArray = val instanceof List ? ((List)val).toArray() : new Object[]{val};
        }
        this._paramTypesArray = null;
        val = desc.getEvaluatedOption(ctx, "paramTypes", parent);
        if (val != null) {
            if (val instanceof String) {
                this._paramTypesArray = new String[]{(String)val};
            } else if (val instanceof List) {
                this._paramTypesArray = ((List)val).toArray(new String[0]);
            } else {
                throw new IllegalArgumentException("'paramTypes' must be a String or a List of types!");
            }
        }
        this._nameAtt = (String)desc.getEvaluatedOption(ctx, "attributeName", parent);
        if (this._nameAtt != null) {
            this._nameAtt = this._nameAtt.trim();
            if (this._nameAtt.length() == 0) {
                this._nameAtt = null;
            }
        }
        this._nameMethod = (String)desc.getEvaluatedOption(ctx, "attrNameMethod", parent);
        if (this._nameMethod != null) {
            this._nameMethod = this._nameMethod.trim();
            if (this._nameMethod.length() == 0) {
                this._nameMethod = null;
            }
        }
        String ignored = (String)desc.getEvaluatedOption(ctx, "ignored", parent);
        try {
            if (ignored == null || "false".equals(ignored)) {
                this.setTreeNodeObject(new ObjectName(this._objectName));
            } else {
                this.setTreeNodeObject(null);
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR: Illegal _objectName: " + this._objectName);
            this.setTreeNodeObject(null);
        }
    }

    public List getChildTreeNodeObjects(Object nodeObject) {
        if (nodeObject == null) {
            return null;
        }
        if (nodeObject.toString().equals(this._objectName)) {
            if (this._children != null) {
                return this._children;
            }
            try {
                AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(this._objectName));
                if (amx == null) {
                    throw new RuntimeException("Unable to get AMXConigProxy for '" + this._objectName + "'!");
                }
                if (this._amxChildType == null || this._amxChildType.equals("")) {
                    ObjectName[] children = amx.getChildren();
                    this._children = new ArrayList();
                    for (int i = 0; i < children.length; ++i) {
                        this._children.add(children[i]);
                    }
                } else {
                    this._children = new ArrayList();
                    Map childrenMap = amx.childrenMap(this._amxChildType);
                    for (AMXProxy oneChild : childrenMap.values()) {
                        this._children.add(((AMXConfigProxy)oneChild).objectName());
                    }
                }
            }
            catch (Exception ex3) {
                // empty catch block
            }
            FacesContext ctx = FacesContext.getCurrentInstance();
            Object retVal = this.getLayoutComponent().dispatchHandlers(ctx, "filterTree", (EventObject)((Object)new FilterTreeEvent(this.getParentUIComponent(), this._children)));
            if (retVal != null && retVal instanceof List) {
                this._children = (List)retVal;
            }
        } else {
            return null;
        }
        return this._children;
    }

    public Map<String, Object> getFactoryOptions(Object nodeObject) {
        if (nodeObject == null) {
            return null;
        }
        LayoutComponent desc = this.getLayoutComponent();
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (nodeObject.toString().equals(this._objectName)) {
            this.setProperty(props, "text", desc.getOption("text"));
            this.setProperty(props, "url", desc.getOption("url"));
            this.setProperty(props, "imageURL", desc.getOption("imageURL"));
            this.setProperty(props, "target", desc.getOption("target"));
            this.setProperty(props, "action", desc.getOption("action"));
            this.setProperty(props, "actionListener", desc.getOption("actionListener"));
            this.setProperty(props, "expanded", desc.getOption("expanded"));
            this.setProperty(props, "rendered", desc.getOption("rendered"));
        } else {
            String check;
            if (nodeObject instanceof ObjectName) {
                if (this._nameAtt != null) {
                    this.setProperty(props, "text", ((ObjectName)nodeObject).getKeyProperty(this._nameAtt));
                }
                if (!props.containsKey("text")) {
                    this.setProperty(props, "text", nodeObject.toString());
                }
            } else if (nodeObject instanceof String) {
                this.setProperty(props, "text", (String)nodeObject);
            } else if (nodeObject instanceof AMXProxy) {
                this.setProperty(props, "text", ((AMXProxy)nodeObject).getName());
            } else {
                throw new RuntimeException("'" + nodeObject + "' Illegal type (" + nodeObject.getClass().getName() + ") for tree processing");
            }
            this.setProperty(props, "url", desc.getOption("childURL"));
            this.setProperty(props, "imageURL", desc.getOption("childImageURL"));
            this.setProperty(props, "target", desc.getOption("childTarget"));
            this.setProperty(props, "action", desc.getOption("childAction"));
            String tt = (String)desc.getOption("targetConfigName");
            if (!GuiUtil.isEmpty(tt)) {
                this.setProperty(props, "targetConfigName", tt);
            }
            if (!GuiUtil.isEmpty(check = (String)desc.getOption("checkAdminServer"))) {
                String serverName = (String)props.get("text");
                if (serverName.equals("server")) {
                    this.setProperty(props, "text", "server (Admin Server)");
                    this.setProperty(props, "serverName", "server");
                } else {
                    this.setProperty(props, "serverName", serverName);
                }
            }
            this.setProperty(props, "encodedText", GuiUtil.encode((String)props.get("text"), null, null));
            this.setProperty(props, "expanded", desc.getOption("childExpanded"));
        }
        return props;
    }

    void setProperty(Map props, String key, Object value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    public String getId(Object nodeObject) {
        if (nodeObject == null) {
            return "nullNodeObject";
        }
        if (nodeObject.toString().equals(this._objectName)) {
            return this.getLayoutComponent().getId(FacesContext.getCurrentInstance(), this.getParentUIComponent());
        }
        return GuiUtil.genId(nodeObject.toString());
    }

    public Map<String, UIComponent> getFacets(UIComponent comp, Object nodeObject) {
        List handlers;
        if (nodeObject == null) {
            return null;
        }
        if (nodeObject.toString().equals(this._objectName)) {
            return null;
        }
        Properties props = new Properties();
        LayoutComponent desc = this.getLayoutComponent();
        this.setProperty(props, "actionListener", desc.getOption("childActionListener"));
        this.setProperty(props, "target", desc.getOption("childTarget"));
        FacesContext ctx = FacesContext.getCurrentInstance();
        ComponentUtil compUtil = ComponentUtil.getInstance((FacesContext)ctx);
        UIComponent imageLink = compUtil.getChild(comp, "imagelink", "com.sun.jsftemplating.component.factory.sun.ImageHyperlinkFactory", props, "image");
        imageLink.setRendererType("com.sun.webui.jsf.ImageHyperlink");
        this.setProperty(props, "text", comp.getAttributes().get("text"));
        UIComponent link = compUtil.getChild(comp, "link", "com.sun.jsftemplating.component.factory.sun.HyperlinkFactory", props, "content");
        link.setRendererType("com.sun.webui.jsf.Hyperlink");
        Object val = desc.getOption("childURL");
        if (val != null) {
            val = desc.resolveValue(ctx, link, val);
            link.getAttributes().put("url", val);
            imageLink.getAttributes().put("url", val);
        }
        if ((val = desc.getOption("childImageURL")) != null) {
            imageLink.getAttributes().put("imageURL", desc.resolveValue(ctx, link, val));
        }
        if ((handlers = desc.getHandlers("childCommand")) != null) {
            link.getAttributes().put("command", handlers);
            imageLink.getAttributes().put("command", handlers);
            ((ActionSource)((Object)link)).addActionListener((ActionListener)CommandActionListener.getInstance());
            ((ActionSource)((Object)imageLink)).addActionListener((ActionListener)CommandActionListener.getInstance());
        }
        return null;
    }

    public Map getHandlersByType(UIComponent comp, Object nodeObject) {
        return null;
    }
}

