/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import com.sun.enterprise.security.ssl.JarSigner;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ASJarSigner
implements PostConstruct {
    public static final String USER_SPECIFIED_ALIAS_PROPERTYNAME = "com.sun.aas.jws.signing.alias";
    private static final String JKS_KEYSTORE_TYPE_VALUE = "jks";
    private static final String DEFAULT_ALIAS_VALUE = "s1as";
    private static final StringManager localStrings = StringManager.getManager(ASJarSigner.class);
    private Logger logger;

    public void postConstruct() {
        this.logger = LogDomains.getLogger(ASJarSigner.class, (String)"javax.enterprise.system.core");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long signJar(File unsignedJar, File signedJar, String alias) throws Exception {
        if (alias == null) {
            alias = DEFAULT_ALIAS_VALUE;
        }
        long startTime = System.currentTimeMillis();
        ASJarSigner aSJarSigner = this;
        synchronized (aSJarSigner) {
            try {
                JarSigner jarSigner = new JarSigner("SHA1", "RSA");
                jarSigner.signJar(unsignedJar, signedJar, alias);
            }
            catch (Throwable t) {
                try {
                    signedJar.delete();
                    throw new Exception(localStrings.getString("jws.sign.errorSigning", (Object)signedJar.getAbsolutePath(), (Object)alias), t);
                }
                catch (Throwable throwable) {
                    long duration = System.currentTimeMillis() - startTime;
                    this.logger.log(Level.FINE, "Signing {0} took {1} ms", new Object[]{unsignedJar.getAbsolutePath(), duration});
                    throw throwable;
                }
            }
            long duration = System.currentTimeMillis() - startTime;
            this.logger.log(Level.FINE, "Signing {0} took {1} ms", new Object[]{unsignedJar.getAbsolutePath(), duration});
        }
        return System.currentTimeMillis() - startTime;
    }

    public static class ASJarSignerException
    extends Exception {
        public ASJarSignerException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

