/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support.datatypes;

import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.DataType;
import org.jvnet.hk2.config.ValidationException;

@Service
public class NonNegativeInteger
implements DataType {
    public void validate(String value) throws ValidationException {
        if (value == null) {
            throw new ValidationException("null value is not of type NonNegativeInteger");
        }
        if (NonNegativeInteger.isTokenized(value)) {
            return;
        }
        try {
            long number = Long.parseLong(value);
            if (number < 0L || number > Integer.MAX_VALUE) {
                String msg = "value: " + number + " not applicable for NonNegativeInteger [0, " + Integer.MAX_VALUE + "] data type";
                throw new ValidationException(msg);
            }
        }
        catch (NumberFormatException e) {
            throw new ValidationException(e);
        }
    }

    static boolean isTokenized(String value) {
        return value != null && value.startsWith("${") && value.endsWith("}");
    }
}

