/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;

public class ReadableArchiveScannerAdapter
extends AbstractAdapter {
    final ReadableArchive archive;

    public ReadableArchiveScannerAdapter(ReadableArchive archive) {
        this.archive = archive;
    }

    public URI getURI() {
        return this.archive.getURI();
    }

    public Manifest getManifest() throws IOException {
        return this.archive.getManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelectedEntries(ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask entryTask, Logger logger) throws IOException {
        Enumeration<String> entries = this.archive.entries();
        byte[] bytes = new byte[52000];
        while (entries.hasMoreElements()) {
            String explodedName;
            String name = entries.nextElement();
            ArchiveAdapter.Entry entry = new ArchiveAdapter.Entry(name, this.archive.getEntrySize(name), false);
            if (selector.isSelected(entry)) {
                InputStream is = null;
                try {
                    try {
                        int read;
                        is = this.archive.getEntry(name);
                        if ((long)bytes.length < entry.size) {
                            bytes = new byte[(int)entry.size];
                        }
                        if ((long)(read = is.read(bytes, 0, (int)entry.size)) != entry.size) {
                            logger.severe("Incorrect file length while reading " + entry.name + " inside " + this.archive.getName() + " of size " + entry.size + " reported is " + read);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Exception while processing " + entry.name + " inside " + this.archive.getName() + " of size " + entry.size, e);
                    }
                    entryTask.on(entry, bytes);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            if (!name.endsWith(".jar") || this.archive.exists(explodedName = name.replaceAll("[/ ]", "__").replace(".jar", "_jar"))) continue;
            ReadableArchive subArchive = null;
            try {
                subArchive = this.archive.getSubArchive(name);
                if (subArchive == null) continue;
                ReadableArchiveScannerAdapter adapter = new ReadableArchiveScannerAdapter(subArchive);
                adapter.onSelectedEntries(selector, entryTask, logger);
            }
            finally {
                if (subArchive == null) continue;
                subArchive.close();
            }
        }
    }

    public void close() throws IOException {
    }
}

