/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.cluster.NodeInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-nodes")
@Scoped(value=PerLookup.class)
@I18n(value="list.nodes.command")
public class ListNodesCommand
implements AdminCommand {
    @Inject
    private Domain domain;
    @Inject
    Servers servers;
    @Inject
    private Nodes nodes;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;
    @Param(optional=true)
    private boolean terse;
    private ActionReport report;
    private ActionReport.MessagePart top;
    private static final String EOL = "\n";
    Logger logger;

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.top = this.report.getTopMessagePart();
        Logger logger = context.getLogger();
        StringBuilder sb = new StringBuilder();
        boolean firstNode = true;
        List nodeList = this.nodes.getNode();
        LinkedList<NodeInfo> infos = new LinkedList<NodeInfo>();
        for (Node n : nodeList) {
            String name = n.getName();
            String type = n.getType();
            String host = n.getNodeHost();
            String installDir = n.getInstallDir();
            if (host == null) {
                host = " ";
            }
            if (firstNode) {
                firstNode = false;
            } else {
                sb.append(EOL);
            }
            if (this.terse) {
                sb.append(name);
            } else if (!this.verbose) {
                sb.append(name + "  " + type + "  " + host);
            }
            if (!this.verbose) continue;
            List serverList = this.servers.getServer();
            String instanceList = new String();
            if (serverList.size() > 0) {
                for (Server server : serverList) {
                    if (!name.equals(server.getNode())) continue;
                    instanceList = instanceList.concat(" " + server.getName() + ",");
                }
                logger.warning(instanceList);
            }
            NodeInfo ni = new NodeInfo(name, host, installDir, type, instanceList);
            infos.add(ni);
        }
        if (this.verbose) {
            this.report.setMessage(NodeInfo.format(infos));
        } else {
            this.report.setMessage(sb.toString());
        }
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

