/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.DirectoryClassLoader;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.JDK;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.component.Habitat;

public class AsadminMain {
    private static String[] copyOfArgs;
    private static String classPath;
    private static String className;
    private static String command;
    private static ProgramOptions po;
    private static Habitat habitat;
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int SUCCESS = 0;
    private static final LocalStringsImpl strings;

    public static void main(String[] args) {
        int minor = JDK.getMinor();
        if (minor < 6) {
            CLILogger.getInstance().printError(strings.get("OldJdk", new Object[]{"" + minor}));
            System.exit(1);
        }
        if (CLIConstants.debugMode) {
            System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
            CLILogger.getInstance().printDebugMessage("CLASSPATH= " + System.getProperty("java.class.path") + "\nCommands: " + Arrays.toString(args));
        }
        ClassLoader ecl = AsadminMain.class.getClassLoader();
        try {
            File inst = new File(System.getProperty("com.sun.aas.installRoot"));
            File ext = new File(new File(inst, "lib"), "asadmin");
            CLILogger.getInstance().printDebugMessage("asadmin extension directory: " + ext);
            if (ext.isDirectory()) {
                ecl = new DirectoryClassLoader(ext, ecl);
            } else {
                CLILogger.getInstance().printMessage(strings.get("ExtDirMissing", new Object[]{ext}));
            }
        }
        catch (IOException ex) {
            CLILogger.getInstance().printMessage(strings.get("ExtDirFailed", new Object[]{ex}));
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(ecl);
        StaticModulesRegistry registry = new StaticModulesRegistry(ecl);
        habitat = registry.createHabitat("default");
        copyOfArgs = new String[args.length];
        System.arraycopy(args, 0, copyOfArgs, 0, args.length);
        classPath = SmartFile.sanitizePaths((String)System.getProperty("java.class.path"));
        className = AsadminMain.class.getName();
        if (args.length == 0) {
            args = new String[]{"multimode"};
        }
        if (args[0].equals("-V")) {
            args = new String[]{"version"};
        }
        command = args[0];
        int exitCode = AsadminMain.executeCommand(args);
        switch (exitCode) {
            case 0: {
                if (po.isTerse()) break;
                CLILogger.getInstance().printDetailMessage(strings.get("CommandSuccessful", new Object[]{command}));
                break;
            }
            case 1: {
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                break;
            }
            case 3: {
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                break;
            }
            case 2: {
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
            }
        }
        CLIUtil.writeCommandToDebugLog(args, exitCode);
        System.exit(exitCode);
    }

    public static int executeCommand(String[] argv) {
        CLICommand cmd = null;
        Environment env = new Environment();
        try {
            if (argv.length > 0 && argv[0].startsWith("-")) {
                Parser rcp = new Parser(argv, 0, ProgramOptions.getValidOptions(), false);
                ParameterMap params = rcp.getOptions();
                po = new ProgramOptions(params, env);
                List<String> operands = rcp.getOperands();
                argv = operands.toArray(new String[operands.size()]);
            } else {
                po = new ProgramOptions(env);
            }
            po.toEnvironment(env);
            po.setProgramArguments(copyOfArgs);
            po.setClassPath(classPath);
            po.setClassName(className);
            if (argv.length == 0) {
                argv = po.isHelp() ? new String[]{"help"} : new String[]{"multimode"};
            }
            command = argv[0];
            habitat.addComponent("environment", (Object)env);
            habitat.addComponent("program-options", (Object)po);
            cmd = CLICommand.getCommand(habitat, command);
            return cmd.execute(argv);
        }
        catch (CommandValidationException cve) {
            CLILogger.getInstance().printError(cve.getMessage());
            if (cmd == null) {
                AsadminMain.printUsage();
            } else {
                CLILogger.getInstance().printError(cmd.getUsage());
            }
            return 1;
        }
        catch (InvalidCommandException ice) {
            CLILogger.getInstance().printError(ice.getMessage());
            try {
                CLIUtil.displayClosestMatch(command, CLIUtil.getAllCommands(habitat, po, env), strings.get("ClosestMatchedLocalAndRemoteCommands"));
            }
            catch (InvalidCommandException e) {
                // empty catch block
            }
            return 1;
        }
        catch (CommandException ce) {
            if (ce.getCause() instanceof ConnectException) {
                CLILogger.getInstance().printError(ce.getMessage());
                try {
                    CLIUtil.displayClosestMatch(command, CLIUtil.getLocalCommands(habitat), strings.get("ClosestMatchedLocalCommands"));
                }
                catch (InvalidCommandException e) {
                    CLILogger.getInstance().printMessage(strings.get("InvalidRemoteCommand", new Object[]{command}));
                }
            } else {
                CLILogger.getInstance().printError(ce.getMessage());
            }
            return 1;
        }
    }

    private static void printUsage() {
        CLILogger.getInstance().printError(strings.get("Asadmin.usage"));
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        strings = new LocalStringsImpl(AsadminMain.class);
        Map systemProps = new ASenvPropertyReader().getProps();
        String ir = "com.sun.aas.installRoot";
        String cr = "com.sun.aas.configRoot";
        String irVal = (String)systemProps.get("com.sun.aas.installRoot");
        String crVal = (String)systemProps.get("com.sun.aas.configRoot");
        if (AsadminMain.ok(irVal)) {
            System.setProperty("com.sun.aas.installRoot", irVal);
        }
        if (AsadminMain.ok(crVal)) {
            System.setProperty("com.sun.aas.configRoot", crVal);
        }
    }
}

