/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="stop-domain")
@Scoped(value=PerLookup.class)
public class StopDomainCommand
extends LocalDomainCommand {
    @Param(name="domain_name", primary=true, optional=true)
    private String userArgDomainName;
    private static final long WAIT_FOR_DAS_TIME_MS = 60000L;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDomainCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.userArgDomainName);
        super.validate();
    }

    protected void initDomain() throws CommandException {
        if (this.programOpts.getHost().equals("localhost")) {
            super.initDomain();
        } else if (this.userArgDomainName != null) {
            throw new CommandException(strings.get("StopDomain.noDomainNameAllowed"));
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        boolean isLocal;
        boolean bl = isLocal = this.getServerDirs().getServerName() != null;
        if (isLocal) {
            if (this.getServerDirs().getLocalPassword() == null) {
                return this.dasNotRunning();
            }
            int adminPort = this.getAdminPort();
            this.programOpts.setPort(adminPort);
            logger.printDebugMessage("Stopping local domain on port " + adminPort);
            this.programOpts.setInteractive(false);
            if (!this.isThisDAS(this.getDomainRootDir())) {
                return this.dasNotRunning();
            }
            logger.printDebugMessage("It's the correct DAS");
        } else {
            if (!DASUtils.pingDASQuietly(this.programOpts, this.env)) {
                return this.dasNotRunning();
            }
            logger.printDebugMessage("DAS is running");
            this.programOpts.setInteractive(false);
        }
        this.doCommand();
        return 0;
    }

    protected int dasNotRunning() throws CommandException, CommandValidationException {
        logger.printWarning(strings.get("StopDomain.dasNotRunning"));
        return 0;
    }

    protected void doCommand() throws CommandException, CommandValidationException {
        RemoteCommand cmd = new RemoteCommand(this.getName(), this.programOpts, this.env);
        cmd.executeAndReturnOutput("stop-domain");
        this.waitForDeath();
    }

    protected void waitForDeath() throws CommandException {
        if (!this.programOpts.isTerse()) {
            System.out.print(strings.get("StopDomain.WaitDASDeath") + " ");
        }
        long startWait = System.currentTimeMillis();
        boolean alive = true;
        int count = 0;
        while (!this.timedOut(startWait)) {
            if (!this.isRunning()) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                if (this.programOpts.isTerse() || count++ % 10 != 0) continue;
                System.out.print(".");
            }
            catch (InterruptedException ex) {}
        }
        if (!this.programOpts.isTerse()) {
            System.out.println();
        }
        if (alive) {
            throw new CommandException(strings.get("StopDomain.DASNotDead", new Object[]{60L}));
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }
}

