/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.cli;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.flashlight.cli.MonitoringConfig;
import org.glassfish.flashlight.impl.client.FlashlightProbeClientMediator;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="enable-monitoring")
@Scoped(value=PerLookup.class)
@I18n(value="enable.monitoring")
public class EnableMonitoring
implements AdminCommand {
    @Inject
    MonitoringService ms;
    @Param(optional=true)
    private String pid;
    @Param(optional=true)
    private String options;
    @Param(optional=true)
    private String modules;
    @Param(optional=true)
    private Boolean mbean;
    @Param(optional=true)
    private Boolean dtrace;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableMonitoring.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!FlashlightProbeClientMediator.isAgentAttached()) {
            if (!this.isValidString(this.pid)) {
                int i = ProcessUtils.getPid();
                if (i == -1) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(this.localStrings.getLocalString("attach.agent.exception", "invalid pid, pl. provide the application server's pid using --pid option, you may get pid using jps command"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                } else {
                    this.pid = String.valueOf(i);
                }
            }
            if (this.isValidString(this.pid)) {
                FlashlightProbeClientMediator.setAgentInitialized(false);
                this.attachAgent(report);
            }
        }
        if (this.modules != null && this.modules.length() > 0) {
            String[] strArr = this.modules.split(":");
            String[] nvArr = null;
            for (String nv : strArr) {
                if (nv.length() <= 0) continue;
                nvArr = nv.split("=");
                if (nvArr.length > 1) {
                    if (!this.isValidString(nvArr[1])) continue;
                    this.setModuleMonitoringLevel(nvArr[0], nvArr[1], report);
                    continue;
                }
                if (!this.isValidString(nvArr[0])) continue;
                this.setModuleMonitoringLevel(nvArr[0], "HIGH", report);
            }
        }
        if (this.mbean != null) {
            MonitoringConfig.setMBeanEnabled(this.ms, this.mbean.toString(), report);
        }
        if (this.dtrace != null) {
            MonitoringConfig.setDTraceEnabled(this.ms, this.dtrace.toString(), report);
        }
        MonitoringConfig.setMonitoringEnabled(this.ms, "true", report);
    }

    private void attachAgent(ActionReport report) {
        ActionReport.MessagePart part = report.getTopMessagePart().addChild();
        this.options = this.options == null ? "unsafe=true,noServer=true" : "unsafe=true,noServer=true," + this.options;
        try {
            VirtualMachine vm = VirtualMachine.attach(this.pid);
            String ir = System.getProperty("com.sun.aas.installRoot");
            File dir = new File(ir, "lib" + File.separator + "monitor");
            if (dir.isDirectory()) {
                File agentJar = new File(dir, "btrace-agent.jar");
                if (agentJar.isFile()) {
                    if (this.options == null) {
                        vm.loadAgent(agentJar.getPath());
                    } else {
                        vm.loadAgent(agentJar.getPath(), this.options);
                    }
                    part.setMessage(this.localStrings.getLocalString("attach.agent.suucess", "btrace agent attached"));
                    report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                } else {
                    part.setMessage(this.localStrings.getLocalString("attach.agent.exception", "btrace-agent.jar does not exist under {0}", new Object[]{dir}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                }
            } else {
                part.setMessage(this.localStrings.getLocalString("attach.agent.exception", "btrace-agent.jar directory {0} does not exist", new Object[]{dir}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
        catch (Exception e) {
            part.setMessage(this.localStrings.getLocalString("attach.agent.exception", "Encountered exception during agent attach {0}", new Object[]{e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void setModuleMonitoringLevel(String moduleName, String level, ActionReport report) {
        ActionReport.MessagePart part = report.getTopMessagePart().addChild();
        if (!this.isValidString(moduleName)) {
            part.setMessage(this.localStrings.getLocalString("enable.monitoring.invalid", "Invalid module name {0}", new Object[]{moduleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (!this.isValidString(level) || !this.isValidLevel(level)) {
            part.setMessage(this.localStrings.getLocalString("enable.monitoring.invalid", "Invalid level {0} for module name {1}", new Object[]{level, moduleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        MonitoringConfig.setMonitoringLevel(this.ms, moduleName, level, report);
    }

    private boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }

    private boolean isValidLevel(String level) {
        return level.equals("OFF") || level.equals("HIGH") || level.equals("LOW");
    }
}

