/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.HttpRedirect;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.cli.CreateHttp;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-http-redirect")
@Scoped(value=PerLookup.class)
@I18n(value="create.http.redirect")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateHttpRedirect
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHttp.class);
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="redirect-port", optional=true)
    String port;
    @Param(name="secure-redirect", optional=true)
    String secure;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        Protocols protocols = this.config.getNetworkConfig().getProtocols();
        Protocol protocol = null;
        for (Protocol p : protocols.getProtocol()) {
            if (!this.protocolName.equals(p.getName())) continue;
            protocol = p;
        }
        if (protocol == null) {
            report.setMessage(localStrings.getLocalString("create.http.redirect.fail.protocolnotfound", "The specified protocol {0} is not yet configured. Please create one", new Object[]{this.protocolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (protocol.getHttpRedirect() != null) {
            report.setMessage(localStrings.getLocalString("create.http.redirect.fail.duplicate", "An http-redirect element for {0} already exists. Cannot add duplicate http-redirect", new Object[]{this.protocolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                @Override
                public Object run(Protocol param) throws TransactionFailure {
                    HttpRedirect httpRedirect = (HttpRedirect)param.createChild(HttpRedirect.class);
                    httpRedirect.setPort(CreateHttpRedirect.this.port);
                    httpRedirect.setSecure(CreateHttpRedirect.this.secure);
                    param.setHttpRedirect(httpRedirect);
                    return httpRedirect;
                }
            }, protocol);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.http.fail", "Failed to create http-redirect for {0}: " + (e.getMessage() == null ? "No reason given." : e.getMessage()), new Object[]{this.protocolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

