/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.store.adapter.cache;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.api.BackingStoreTransaction;
import org.glassfish.ha.store.spi.BackingStoreFactoryRegistry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="replication")
public class ReplicationStoreProxy2
implements Startup,
PostConstruct,
BackingStoreFactory {
    @Inject
    Habitat habitat;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    @Override
    public <K extends Serializable, V extends Serializable> BackingStore<K, V> createBackingStore(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        try {
            BackingStoreFactory storeFactory = (BackingStoreFactory)this.habitat.getComponent(BackingStoreFactory.class, "shoal-backing-store-factory");
            return storeFactory.createBackingStore(conf);
        }
        catch (Exception ex) {
            throw new BackingStoreException("Exception while created shoal cache", ex);
        }
    }

    public void postConstruct() {
        BackingStoreFactoryRegistry.register("replication", this);
        Logger.getLogger(ReplicationStoreProxy2.class.getName()).log(Level.INFO, "Registered ReplicationStoreProxy with persistence-type = replication");
    }

    @Override
    public BackingStoreTransaction createBackingStoreTransaction() {
        try {
            BackingStoreFactory storeFactory = (BackingStoreFactory)this.habitat.getComponent(BackingStoreFactory.class, "shoal-backing-store-factory");
            return storeFactory.createBackingStoreTransaction();
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while created shoal cache", ex);
        }
    }
}

