/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.versioning;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Domain;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.deployment.common.VersioningDeploymentException;
import org.glassfish.deployment.common.VersioningDeploymentSyntaxException;
import org.glassfish.deployment.common.VersioningDeploymentUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@I18n(value="versioning.service")
@Service
@Scoped(value=PerLookup.class)
public class VersioningService {
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private Domain domain;

    public final List<String> getAllversions(String untaggedName, String target) {
        List allApplications = null;
        allApplications = target != null ? this.domain.getApplicationsInTarget(target) : this.domain.getApplications().getApplications();
        return VersioningDeploymentUtil.getVersions((String)untaggedName, (List)allApplications);
    }

    public final String getEnabledVersion(String name, String target) throws VersioningDeploymentSyntaxException {
        String untaggedName = VersioningDeploymentUtil.getUntaggedName((String)name);
        List<String> allVersions = this.getAllversions(untaggedName, target);
        if (allVersions != null) {
            for (String app : allVersions) {
                if (!this.domain.isAppEnabledInTarget(app, target)) continue;
                return app;
            }
        }
        return null;
    }

    public final List<String> getMatchedVersions(String name, String target) throws VersioningDeploymentSyntaxException, VersioningDeploymentException {
        String untagged = VersioningDeploymentUtil.getUntaggedName((String)name);
        List<String> allVersions = this.getAllversions(untagged, target);
        if (allVersions.size() == 0) {
            if (!name.equals(untagged)) {
                throw new VersioningDeploymentException(VersioningDeploymentUtil.LOCALSTRINGS.getLocalString("versioning.deployment.application.noversion", "Application {0} has no version registered", new Object[]{untagged}));
            }
            return Collections.EMPTY_LIST;
        }
        return VersioningDeploymentUtil.matchExpression(allVersions, (String)name);
    }

    public void handleDisable(String appName, String target, ActionReport report) throws VersioningDeploymentSyntaxException {
        String enabledVersion = this.getEnabledVersion(appName, target);
        if (enabledVersion != null && !enabledVersion.equals(appName)) {
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"DEFAULT", (Object)enabledVersion);
            parameters.add((Object)"target", (Object)target);
            ActionReport subReport = report.addSubActionsReport();
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("disable", subReport);
            inv.parameters(parameters).execute();
        }
    }

    public String getVersionFromSameDir(File dir) throws VersioningDeploymentSyntaxException {
        try {
            Iterator it = this.domain.getApplications().getApplications().iterator();
            Application app = null;
            while (it.hasNext()) {
                app = (Application)it.next();
                if (!app.getLocation().equals(dir.toURI().toString()) || VersioningDeploymentUtil.getUntaggedName((String)app.getName()).equals(app.getName())) continue;
                return app.getName();
            }
        }
        catch (VersioningDeploymentSyntaxException versioningDeploymentSyntaxException) {
            // empty catch block
        }
        return null;
    }
}

